#include "GridDialog.h"
#include <qstring.h>

GridDialog::GridDialog( QWidget *parent, char *name, int actGrid )
	: QDialog( parent, name, TRUE ),
		gridEdit( this ),
		enableGrid( "Enable Grid:", this ),
		okButton( "OK", this ),
		canButton( "Cancel", this )
{
	grid = actGrid;

	setCaption( "Grid ..." );

	// Layout
	enableGrid.setGeometry( 10, 16, 60, 20 );
	gridEdit.setGeometry( 76, 16, 40, 20 );

	okButton.setGeometry( 10, 50, 40, 20 );
	canButton.setGeometry( 76, 50, 40, 20 );
	
	adjustSize();

	// Fill known content
	if( grid > 1 )
	{
		enableGrid.setChecked( TRUE );
		gridEdit.setEnabled( TRUE );

		QString aString;
		aString.setNum( grid );
		gridEdit.setText( aString );
	}	else
	{
		enableGrid.setChecked( FALSE );
		gridEdit.setEnabled( FALSE );
	}

	// Connecting
	connect( &enableGrid, SIGNAL(toggled(bool)), SLOT(EnableGrid(bool)) );
	connect( &okButton, SIGNAL(clicked()), SLOT(OKFunc()) );
	connect( &canButton, SIGNAL(clicked()), SLOT(reject()) );

	// Already enabled ?
}

int GridDialog::GetNewGrid()
{
	return grid;
}

void GridDialog::EnableGrid( bool on )
{
	if( on )
		gridEdit.setEnabled( TRUE );
	else
		gridEdit.setEnabled( FALSE );
}

void GridDialog::OKFunc()
{
	if( enableGrid.isChecked() )
	{
		QString aString( gridEdit.text() );
		grid = aString.toInt();
	}	else
	{
		grid = 1;
	}

	accept();
}

