#include "GuiTools.h"


QStrList GuiTools::itsQDialogSlots;


void GuiTools::SetVisible( QWidget*	widget,
			   bool		visible )
{
    if( visible )
    {
	widget->show();
    }
    else
    {
	widget->hide();
    }
}


void GuiTools::TransferListBox( const QListBox*	source,
				QListBox*	dest )
{
    dest->clear();
    for( unsigned int i = 0; i < (unsigned int)source->count(); i++ )
        dest->insertItem( source->text( i ) );
}    


void GuiTools::TransferListFromCombo( const QComboBox*	source,
				      QListBox*		dest )
{
    dest->clear();
    for( unsigned int i = 0; i < (unsigned int)source->count(); i++ )
        dest->insertItem( source->text( i ) );
}


void GuiTools::TransferListToCombo( QComboBox*		dest,
				    const QListBox*	source )
{
    dest->clear();
    for( unsigned int i = 0; i < (unsigned int)source->count(); i++ )
        dest->insertItem( source->text( i ) );
}


QString GuiTools::QFontStyleHintStr( QFont::StyleHint	hint )
{
    QString str;
    
    switch( hint )
    {
	case QFont::Helvetica:
	default:
	{
	    str = "Helvetica";
	    break;
	}
	case QFont::Times:
	{
	    str = "Times";
	    break;
	}
	case QFont::Courier:
	{
	    str = "Courier";
	    break;
	}
	case QFont::OldEnglish:
	{
	    str = "Old English";
	    break;
	}
	case QFont::System:
	{
	    str = "System";
	    break;
	}
	case QFont::AnyStyle:
	{
	    str = "AnyStyle";
	    break;
	}
    }

    return str;
}


QFont::StyleHint GuiTools::QFontStyleHint( QString	str )
{
    QFont::StyleHint hint = QFont::Helvetica;
    
    if( (str == "Helvetica") || (str == "Sans Serif") )
    {
	// already set to helvetica
    }
    else if( (str == "Times") || (str == "Serif") )
    {
	hint = QFont::Times;
    }
    else if( (str == "Courier") || (str == "Type Writer") )
    {
	hint = QFont::Courier;
    }
    else if( (str == "Old English") || (str == "Decorative") )
    {
	hint = QFont::OldEnglish;
    }
    else if( str == "System" )
    {
	hint = QFont::System;
    }
    else if( str == "Any Style" )
    {
	hint = QFont::AnyStyle;
    }

    return hint;
}



QString GuiTools::QFontWeightStr( int	weight )
{
    QString str;
    str.setNum( weight );
    
    switch( weight )
    {
	case QFont::Light:
	{
	    str = "Light";
	    break;
	}
	case QFont::Normal:
	{
	    str = "Normal";
	    break;
	}
	case QFont::DemiBold:
	{
	    str = "DemiBold";
	    break;
	}
	case QFont::Bold:
	{
	    str = "Bold";
	    break;
	}
	case QFont::Black:
	{
	    str = "Black";
	    break;
	}
    }

    return str;
}


QString GuiTools::QFontCharSetStr( QFont::CharSet	set )
{
    QString str;
    
    switch( set )
    {
	case QFont::Latin1:
	{
	    str = "Latin1";
	    break;
	}
	case QFont::AnyCharSet:
	{
	    str = "Any Char Set";
	    break;
	}
    }
    
    return str;
}


QFont::CharSet GuiTools::QFontCharSet( QString		set )
{
    QFont::CharSet charSet = QFont::Latin1;
    
    if( (set == "Latin1") || (set == "ISO_8859_1") )
    {
	// already set to Latin1
    }
    else if( set == "Any Char Set" )
    {
	charSet = QFont::AnyCharSet;
    }
    
    return charSet;
}


void GuiTools::QStrListAppendAll( QStrList&		to,
				  const QStrList&	from )
{
    QStrListIterator iter( from );
    char* item;
    
    while( (item = iter()) )
    {
	to.append( item );
    }
}


QString GuiTools::QLCDNumberSegStyleStr( QLCDNumber::SegmentStyle	style )
{
    QString str = "Outline";
    
    switch( style )
    {
	case QLCDNumber::Outline:
	default:
	{
	    // already set to Outline
	    break;
	}
	case QLCDNumber::Filled:
	{
	    str = "Filled";
	    break;
	}
	case QLCDNumber::Flat:
	{
	    str = "Flat";
	    break;
	}
    }
    
    return str;
}


QLCDNumber::SegmentStyle GuiTools::QLCDNumberSegStyle( QString		str )
{
    QLCDNumber::SegmentStyle style = QLCDNumber::Outline;
    
    if( str == "Filled" )
    {
	style = QLCDNumber::Filled;
    }
    else if( str == "Flat" )
    {
	style = QLCDNumber::Flat;
    }
    
    return style;
}


QString GuiTools::QLineEditEchoModeStr( QLineEdit::EchoMode	mode )
{
    QString str= "Normal";
    
    switch( mode )
    {
	case QLineEdit::Normal:
	default:
	{
	    // already set to Normal
	    break;
	}
	case QLineEdit::NoEcho:
	{
	    str = "NoEcho";
	    break;
	}
	case QLineEdit::Password:
	{
	    str = "Password";
	    break;
	}
    }
    
    return str;
}


QLineEdit::EchoMode GuiTools::QLineEditEchoMode( QString	str )
{
    QLineEdit::EchoMode echo = QLineEdit::Normal;
    
    if( str == "NoEcho" )
    {
	echo = QLineEdit::NoEcho;
    }
    else if( str == "Password" )
    {
	echo = QLineEdit::Password;
    }
    
    return echo;
}


QString GuiTools::QSliderTickSettingStr( QSlider::Orientation	orient,
					 QSlider::TickSetting	tick )
{
    QString str = "NoMarks";
    

    if( orient == QSlider::Vertical )
    {
	if( tick == QSlider::Left )
	{
	    str = "Left";
	}
	else if( tick == QSlider::Right )
	{
	    str = "Right";
	}
    }
    else if( orient == QSlider::Horizontal )
    {
	if( tick == QSlider::Above )
	{
	    str = "Above";
	}
	else if( tick == QSlider::Below )
	{
	    str = "Below";
	}
    }

    if( tick == QSlider::Both )
    {
	str = "Both";
    }
    
    return str;
}


QSlider::TickSetting GuiTools::QSliderTickSetting( QString	str )
{
    QSlider::TickSetting tick = QSlider::NoMarks;
    
    if( str == "Above" )
    {
	tick = QSlider::Above;
    }
    else if( str == "Left" )
    {
	tick = QSlider::Left;
    }
    else if( str == "Below" )
    {
	tick = QSlider::Below;
    }
    else if( str == "Right" )
    {
	tick = QSlider::Right;
    }
    else if( str == "Both" )
    {
	tick = QSlider::Both;
    }
    
    return tick;
}


const QStrList& GuiTools::GetQDialogSlots( void )
{
    if( itsQDialogSlots.isEmpty() )
    {
	itsQDialogSlots.append( "done(int)" );
	itsQDialogSlots.append( "accept()" );
	itsQDialogSlots.append( "reject()" );
    }
    
    return itsQDialogSlots;
}

