%{
#include <qstring.h>
#include <qregexp.h>
#include "DlgParser.h"
%}

CHARS [A-Za-z]
WORD {CHARS}+[0-9]*
WIDGETS_A Button|ButtonGroup|CheckBox|ComboBox|Frame|GroupBox
WIDGETS_B LCDNumber|Label|LineEdit|ListBox|MenuBar|PushButton
WIDGETS_C RadioButton|ScrollBar|MultiLineEdit|User|Slider
LAYOUT    WidgetLayout
PROJECT   Project
DIALOG    Dialog
WIDGETS {WIDGETS_A}|{WIDGETS_B}|{WIDGETS_C}
%x InsideLayout
%x InsideWidget
%x InsideDialog
%x InsideProject

%%
%{
%}

<*>[ \t]*  /* Whitespaces are ignored */
<*>\n { 
  if( gDlgParser )
    gDlgParser->lineNumber++; 
}

{PROJECT} {
  // Skipping Whitespaces up to (and including) opening bracket
  int c;
  while( (c = yyinput()) != '{' && c != EOF );

  // Not really a widget, but handled as one for now
  BEGIN(InsideProject);

  return (int) ProjectDataStart;
}

{DIALOG} { 
  if( gDlgParser )
    gDlgParser->widgetType = yytext;

  // Skipping Whitespaces up to (and including) opening bracket
  int c;
  while( (c = yyinput()) != '{' && c != EOF );

  // Not really a widget, but handled as one for now
  BEGIN(InsideDialog);

  return (int) DialogDataStart;
}

{LAYOUT} { 
  if( gDlgParser )
    gDlgParser->widgetType = yytext;

  // Skipping Whitespaces up to (and including) opening bracket
  int c;
  while( (c = yyinput()) != '{' && c != EOF );

  BEGIN(InsideLayout);

  return (int) LayoutDataStart;
}

<InsideLayout>{WIDGETS} { 
  if( gDlgParser )
    gDlgParser->widgetType = yytext;

  // Skipping Whitespaces up to (and including) opening bracket
  int c;
  while( (c = yyinput()) != '{' && c != EOF );

  BEGIN(InsideWidget);

  return (int) WidgetDataStart;
}

\{ { 
  fprintf( stderr, "Error in line %d\n", gDlgParser->lineNumber );
  if( gDlgParser )
    gDlgParser->errorCount++;
  return (int) ErrorInInput;
}

<InsideWidget>\} {
  BEGIN(InsideLayout);
  return (int) WidgetDataEnd;
}

<InsideLayout>\} {
  BEGIN(0);
  return (int) LayoutDataEnd;
}

<InsideDialog>\} {
  BEGIN(0);
  return (int) DialogDataEnd;
}

<InsideProject>\} {
  BEGIN(0);
  return (int) ProjectDataEnd;
}

<*>{WORD} {
  if( gDlgParser )
    gDlgParser->key = yytext;

  // Skipping Whitespaces up to opening bracket
  int c;
  while( (c = yyinput()) != '{' && c != EOF );
  unput( c );
}

<*>\{[^}]*\} {
  QString str( yytext );
  // Removing tabs and newlines
  str.replace( QRegExp( "\n" ), " " );
  str.replace( QRegExp( "\t" ), " " );

  // Removing leading and trailing curly bracket
  str = str.mid( 1, str.length() - 2 );

  if( gDlgParser )
    gDlgParser->value = str;

  int retVal;
  switch( YY_START )
  {  
case InsideDialog : retVal = (int) DialogData; break;
case InsideLayout : retVal = (int) LayoutData; break;
case InsideWidget : retVal = (int) WidgetData; break;
case InsideProject: retVal = (int) ProjectData; break;
default          : retVal = (int) ErrorInInput; break;
  }
  return retVal;
}

%%






