// $Id: ProjectWnd.cpp,v 1.4 1997/04/23 03:04:44 jharris Exp $

#include <qapp.h>
#include <qdir.h>
#include <qtstream.h>
#include <qfile.h>
#include <qfiledlg.h>
#include <qkeycode.h>
#include <qpopmenu.h>
#include <qmsgbox.h>
#include <qpixmap.h>
#include <qregexp.h>
#include <qclipbrd.h>

#include "ProjectWnd.h"
#include "GenerateDialog.h"
#include "DlgParser.h"
#include "Dialog.h"

#include "widget/DlgWidget.h"

// bitmaps
#include "bmp/bitmaps.h"

#define Inherited QFrame

ProjectWnd::ProjectWnd( QWidget* parent,
		      const char* name )
    : 
    Inherited( parent, name ),
    itsLayout( this, QBoxLayout::Down ),
    itsMenu( this, name ),
    itsObjectList( this, "dialogList" ),
    itsToolbar( this, name ),
    autoGenerate( FALSE )
{
    QPixmap pixmap;

    setCaption( "Qt Dialog Editor" );
    //setFrameStyle( QFrame::Panel | QFrame::Raised );

    pixmap.loadFromData( Dlgedit_bmp_data, Dlgedit_bmp_len );
    setIcon( pixmap );
    setIconText( caption() );

    itsMenu.setFrameStyle( WinPanel | Raised );
    
    // setup menu items
    QPopupMenu* file = new QPopupMenu;
    file->insertItem( "New Dialog...", this, SLOT(DialogNew()), CTRL+Key_N );
    file->insertItem( "Open Dialog...", this, SLOT(DialogOpen()), CTRL+Key_O );
    file->insertSeparator();
    file->insertItem( "New Project...", this, SLOT(ProjectNew()) );
    file->insertItem( "Open Project...", this, SLOT(ProjectOpen()) );
    file->insertSeparator();
    file->insertItem( "Save All", this, SLOT(ObjectSave()) );
    file->insertSeparator();
    file->insertItem( "Generate Objects", this, SLOT(ObjectGenerate()), 
		      CTRL + Key_G );
    file->insertSeparator();
    file->insertItem( "Exit", this, SLOT(quit()), CTRL + Key_X );

    itsMenu.insertItem( "File", file );

    itsLayout.setMenuBar( &itsMenu );

    // Create initial layout (implizit new Window)
  
    pixmap.loadFromData( NewProject_bmp_data, NewProject_bmp_len );
    itsNewProjectButton = itsToolbar.Insert( pixmap, this, SLOT(ProjectNew()),
					     "New Project" );
    pixmap.loadFromData( NewDialog_bmp_data, NewDialog_bmp_len );
    itsNewDialogButton = itsToolbar.Insert( pixmap, this, SLOT(DialogNew()), 
					    "New Dialog" );
    itsToolbar.InsertSeparator();
    pixmap.loadFromData( OpenProject_bmp_data, OpenProject_bmp_len );
    itsToolbar.Insert( pixmap, this, SLOT(ProjectOpen()),
		       "Open Project" );
    pixmap.loadFromData( OpenDialog_bmp_data, OpenDialog_bmp_len );
    itsToolbar.Insert( pixmap, this, SLOT(DialogOpen()),
		       "Open Dialog" );
    itsToolbar.InsertSeparator();
    pixmap.loadFromData( SaveDialogs_bmp_data, SaveDialogs_bmp_len );
    itsSaveAllButton = itsToolbar.Insert( pixmap, this, SLOT(ObjectSave()),
					  "Save All Open Files" );
    itsToolbar.InsertSeparator();
//   pixmap.loadFromData( GenerateProject_bmp_data, Generate_bmp_len );
//   itsGenerateProjectButton = itsToolbar.Insert( pixmap, this, 
//                                                 SLOT(ProjectsGenerate()),
//                                                 "Generate All Projects" );
    pixmap.loadFromData( Generate_bmp_data, Generate_bmp_len );
    itsGenerateButton = itsToolbar.Insert( pixmap, this, SLOT(ObjectGenerate()),
					   "Generate All" );

    itsLayout.addSpacing( 3 );
    itsLayout.addWidget( &itsToolbar );
    itsToolbar.setMinimumSize( 0, itsToolbar.geometry().height()  );

    itsLayout.addSpacing( 5 );

    QBoxLayout* listLayout = new QBoxLayout( QBoxLayout::LeftToRight, 5 );
    itsLayout.addLayout( listLayout, 1 );

    listLayout->addSpacing( 5 );
    listLayout->addWidget( &itsObjectList, 1 );
    itsObjectList.resize( 200,100 );
    listLayout->addSpacing( 5 );

    itsLayout.addSpacing( 5 );

    itsLayout.activate();

    resize( 250, 150 );

    itsObjects.setAutoDelete( FALSE );

    connect( QApplication::clipboard(), SIGNAL(dataChanged()),
	     SLOT(ClipBoardChanged()) );

    Update();
}


ProjectWnd::~ProjectWnd()
{
}


DlgObject* ProjectWnd::CreateNewObject( DlgObjectType type )
{
  static int     defNumber = 1;
  QString extension;

  DlgObject *obj;

  switch( type )
  {
  case DlgObject_Dialog:
    obj = new Dialog( *this, "" );
    break;
  case DlgObject_Project:
    obj = new Project( *this, "" );
    break;
  }

  extension = obj->GetExtension();

  QString tmp;
  do
  {
      tmp.setNum( defNumber++ );
      tmp = "Untitled-" + tmp + "." + extension;
  } while( itsObjectList.Contains( tmp ) );
  
  obj->SetName( tmp );

  if( !autoGenerate )
  {
      obj->Show();
  }

  itsObjects.append( obj );

  ProcessNewObject( obj );
  return obj;
}

void ProjectWnd::ObjectOpen( DlgObjectType type )
{
    QString str;
    
  //  str = QFileDialog::getOpenFileName( NULL, obj->GetExtension() );
    str = QFileDialog::getOpenFileName( NULL, 
					"*." + DlgObject::GetExtension(type) );
    
    if( !str.isEmpty() )
    {
	ObjectLoad( str, NULL );
    }
}

DlgObject *ProjectWnd::ObjectLoad( const QString &fileName, Project *prj )
{
  DlgObject *obj = DlgObject::NewObject( *this, fileName );

  obj->SetName( fileName, FALSE );
  obj->Load();

  if( !autoGenerate )
  {
      obj->Show();
  }

  if( prj )
    obj->EnterProject( prj );
  else
    itsObjects.append( obj );

  ProcessNewObject( obj );
  return obj;
}

void ProjectWnd::ProcessNewObject( DlgObject *obj )
{
  itsObjectList.Append( obj );

  connect( obj, SIGNAL(Changed(DlgObject*)), 
           &itsObjectList, SLOT(Update(DlgObject*)) );
  connect( obj, SIGNAL(Saved(DlgObject*)),
           &itsObjectList, SLOT(Saved(DlgObject*)) );
  connect( obj, SIGNAL(Closed(DlgObject*)), SLOT(Closed(DlgObject*)) );
  connect( obj, SIGNAL(CPDataSet(DlgObject*)), SLOT(NewCPBuffer(DlgObject*)) );
  connect( this, SIGNAL(CPBufferAvailable(bool)), obj,
           SLOT(CPAvailable(bool)) );

  ClipBoardChanged();
    Update();
}


void ProjectWnd::ObjectSave()
{
  for( DlgObject *obj = itsObjects.first();
       obj;
       obj = itsObjects.next() )
  {
    QString name = obj->GetName();

    if( name.isEmpty() )
    {
      name = QFileDialog::getSaveFileName( NULL, "*." + obj->GetExtension() );

      if( name.isEmpty() )
        continue;

      obj->SetName( name );
    }      
    
    obj->Save();
  }
}

void ProjectWnd::ObjectGenerate()
{
  for( DlgObject *obj = itsObjects.first();
       obj;
       obj = itsObjects.next() )
  {
      obj->Generate( autoGenerate );
  }

}

void ProjectWnd::DialogNew()
{
  CreateNewObject( DlgObject_Dialog );
}

void ProjectWnd::DialogOpen()
{
  ObjectOpen( DlgObject_Dialog );
}

void ProjectWnd::ProjectNew()
{
  CreateNewObject( DlgObject_Project );
}

void ProjectWnd::ProjectOpen()
{
  ObjectOpen( DlgObject_Project );
}

void ProjectWnd::quit()
{
	qApp->exit( 0 );
}


void ProjectWnd::Closed( DlgObject* obj )
{
  // shut up
  obj = obj;
    Update();
}


void ProjectWnd::ResetContents( void )
{
}


void ProjectWnd::AutoGenerate( void )
{
    autoGenerate = TRUE;

    int i;
    for( i = 2; i < qApp->argc(); i++ )
    {
	    ObjectLoad( qApp->argv()[i] );
    }

    ObjectGenerate();

    quit();
}


void ProjectWnd::Update( void )
{
    itsToolbar.EnableItem( itsNewProjectButton, TRUE );
    itsToolbar.EnableItem( itsNewDialogButton, TRUE );

    bool b = itsObjectList.count() != 0;
    
    itsToolbar.EnableItem( itsSaveAllButton, b );
    itsToolbar.EnableItem( itsGenerateButton, b );
    //itsToolbar.EnableItem( itsGenerateProjectButton, b );
}

void ProjectWnd::NewCPBuffer( DlgObject *obj )
{
  // shut up
  obj = obj;

  QClipboard *cb = QApplication::clipboard();

  cb->clear();
  cb->setText( cpBuffer );

  emit CPBufferAvailable( TRUE );
}

void ProjectWnd::ClipBoardChanged()
{
  QClipboard *cb = QApplication::clipboard();

  const char *tst = cb->text();

  if( tst && ! strncmp( tst, "DlgEdit", 7 ) )
  {
    cpBuffer = tst;
    emit CPBufferAvailable( TRUE );
  } else
  {
    emit CPBufferAvailable( FALSE );
  }
}   

QString ProjectWnd::GetCPFileName()
{
  QFile outFile( tempFile );
  outFile.open( IO_WriteOnly );

  QTextStream current( &outFile );

  current << cpBuffer << endl;

  outFile.close();
  
  return tempFile;
}

