// $Id: 

#ifndef ProjectWnd_included
#define ProjectWnd_included

#include <qframe.h>
#include <qmenubar.h>
#include <qstring.h>
#include <qlayout.h>

class Project;
#include "Dialog.h"
#include "Project.h"
#include "ObjectList.h"
#include "Toolbar.h"

class DlgParser;

class ProjectWnd : public QFrame
{
  Q_OBJECT

public:
  ProjectWnd
  ( 
   QWidget* parent = NULL, 
   const char* name = NULL 
   );

    virtual ~ProjectWnd();

    void AutoGenerate( void );
    // automatically generate the commang line arguments starting at argc 2

    bool IsAutoGenerating( void );
    // true if program is automatically generating

  DlgObject *ObjectLoad( const QString &, Project * = NULL );
  // Load the object

    void FileOpen( const QString& filename );
    // open this dialog

    void ProjectOpen( const QString& filename );
    // open this project

  void SetTempFile( const QString & );
  // Set the c&p working file (used by main.cpp)

  QString &GetCPBuffer();
  // Get the actual contents of the c&p buffer 

  QString GetCPFileName();
  // retrieve the temp. filename where we buffer the c&p data

signals:
  void CPBufferAvailable( bool );

public slots:
 void NewCPBuffer( DlgObject * );
  // Could be used to notify when a subwindow puts st into the cpBuffer

private: // methods

  void ResetContents( void );
  // clear and reset the project

  void LoadDialog( Dialog & );
  // loads the project from the file

  void SaveDialog( Dialog & );
  // save the project to the file

  DlgObject *CreateNewObject( DlgObjectType );
  // Create a new Object

  void ProcessNewObject( DlgObject *obj );
  // Things to do after creating or loading an object
  
  void ObjectOpen( DlgObjectType );
  // Opens an existing Object

    void Update( void );
    // called when the display is updated

private slots:

  void ObjectSave();
  void ObjectGenerate();

  void DialogNew();
  void DialogOpen();
  void ProjectNew();
  void ProjectOpen();

  void ClipBoardChanged();

  void Closed( DlgObject * );

    void quit();

private: // attributes

    QBoxLayout itsLayout;
    // geometry layout manager

  QMenuBar		itsMenu;
  // the menu

  QPopupMenu *windowMenu;
  // the window menu

  QList<DlgObject> itsObjects;
  // All the dialogs

  DlgParser *itsParser;
  // The Parser object which read the input for FileOpen

  QString	itsDlgFilename;
  // filename of the dialog

  ObjectList itsObjectList;
  // Visible list of loaded objects

  enum PopupEntryId {
    IDDlgSave,
    IDDlgSaveAs,
    IDDlgClose,
    IDDlgRaise,
    IDPrjRename,
    IDPrjSave,
    IDPrjSaveAs,
    IDPrjClose,
    IDPrjAddDlg,
    IDPrjGenDlg,
    IDDlgPrjSave,
    IDDlgPrjSaveAs,
    IDDlgPrjRaise,
    IDDlgPrjRemove,
    IDClsDlgPrjOpen,
    IDClsDlgPrjRemove,
    IDLastList
  };

  int popupIds[IDLastList];
  // The ids of all popup entries

    Toolbar	itsToolbar;
    // toolbar for the window

    uint	itsNewProjectButton;
    uint	itsNewDialogButton;
    uint	itsSaveAllButton;
    uint	itsGenerateButton;
    uint	itsGenerateProjectButton;
    // toolbar buttons

    friend class Project;

    friend class DialogList;

    bool	autoGenerate;
    // flag to tell if you should automatically generate from command line
  
  QString tempFile;
  // The temp. file used by c&p

  QString cpBuffer;
  // The actual cut & paste buffer
  
};

inline void ProjectWnd::SetTempFile( const QString &tf )
{
  tempFile = tf;
}

inline QString & ProjectWnd::GetCPBuffer( )
{
  return cpBuffer;
}


inline bool ProjectWnd::IsAutoGenerating( void )
{
    return autoGenerate;
}


#endif // ProjectWnd_included


