#include "Toolbar.h"

#define Inherited QFrame


Toolbar::Toolbar
(
    QWidget*	parent,
    const char*	name
)
    :
    Inherited( parent, name ),
    itsSize( 3, 0 ),
    itsToolTipGroup( this )
{
    itsButtonList.setAutoDelete( FALSE );

    setFrameStyle( WinPanel | Sunken );
    resize( width(), 32 );
}


Toolbar::~Toolbar()
{
}


uint Toolbar::Insert
(
    const QPixmap&	pixmap,
    const QObject*	receiver,
    const char*		slot,
    const char*		toolTip,
    const char*		longToolTip
)
{
    QPushButton* button = new QPushButton( this );
    itsButtonList.append( button );
    button->setPixmap( pixmap );
    button->adjustSize();
    button->move( itsSize.width(), 3 );
    itsSize.rwidth() += button->width();
    itsSize.rheight() = button->height() > itsSize.height() ? 
	button->height() : itsSize.height();

    resize( itsSize.width() + 3, itsSize.height() + 6 );
    
    if( receiver && slot )
    {
	receiver->connect( button, SIGNAL(clicked()), slot );
    }

    if( toolTip )
    {
	if( longToolTip )
	{
	    QToolTip::add( button, toolTip, &itsToolTipGroup, longToolTip );
	}
	else
	{
	    QToolTip::add( button, toolTip );
	}
    }

    return itsButtonList.count() - 1;
}


void Toolbar::EnableItem
(
    uint	item,
    bool	enable
)
{
    QPushButton* button = itsButtonList.at( item );
    if( button )
    {
	button->setEnabled( enable );
    }
}



