#include <qpainter.h>

#include "WidgetFrame.h"
#include "WidgetLayout.h"

#define Inherited QFrame

WidgetFrame::WidgetFrame( QWidget* 	parent,
			  const char*	name )
    :
    Inherited( parent, name )
{
    itsMenu = new QPopupMenu(NULL);
}


WidgetFrame::~WidgetFrame()
{
}


void WidgetFrame::Init( WidgetLayout*	layout )
{
    itsMenu->insertItem( "Properties", layout, 
			 SLOT(SelectedWidgetProperties()) );
}


int  WidgetFrame::DoPropertyDialog()
{
//     WidgetFrameProp dlg( itsCaption, itsWindowType, isDialogModal );
    
//     int rc = dlg.exec();
    
//     if( rc == QDialog::Accepted )
//     {
// 	dlg.GetData( itsCaption, itsWindowType, isDialogModal );
//     }
    
//     return rc;
    return 1;
}


void WidgetFrame::paintEvent( QPaintEvent *theEvent )
{
    QFrame::paintEvent( theEvent );

	// No grid, no action
    if( actGrid >= 2 )
    {
	QPainter painter;
	painter.begin( this );
	for( int x = actGrid; x < this->width(); x += actGrid )
	    for( int y = actGrid; y < this->height(); y += actGrid )
	    {
		painter.drawPoint( x, y );
	    }
	painter.end();
    }
    
    emit Paint( this );
}

void WidgetFrame::SetGrid( int grid )
{
	// Never accept < 1
	if( grid < 1 )
		grid = 1;
	
	actGrid = grid;

	repaint();
}


void WidgetFrame::mousePressEvent
(
    QMouseEvent*	event
)
{
    QFrame::mousePressEvent( event );

    emit MousePress( this, event );

    if( event->button() & RightButton )
    {
	itsMenu->popup( mapToGlobal(event->pos()) );
    }
}


void WidgetFrame::mouseMoveEvent
(
    QMouseEvent*	event
)
{
    QFrame::mouseMoveEvent( event );

    emit MouseMove( this, event );
}


void WidgetFrame::mouseReleaseEvent
(
    QMouseEvent*	 event
)
{
    QFrame::mouseReleaseEvent( event );

    emit MouseRelease();
}

void WidgetFrame::resizeEvent
(
    QResizeEvent*	event
)
{
    QFrame::resizeEvent( event );
    
    emit Resize( this );
}
