#ifndef WidgetFrame_h
#define WidgetFrame_h

#include <qframe.h>
#include <qpopmenu.h>

//#include "prop/WidgetFrameProp.h"

class WidgetLayout;

class WidgetFrame : public QFrame
{
    Q_OBJECT

public: //Methods

    WidgetFrame( QWidget*	parent = NULL, 
		 const char*	name = NULL );

    virtual ~WidgetFrame();

    void Init( WidgetLayout* layout );

    void SetGrid( int );

    int GetGrid( ) const;

    int DoPropertyDialog( void );


signals:

    void MousePress
    (
	QWidget*	widget,
	QMouseEvent*	event
    );

    void MouseMove
    (
	QWidget*	widget,
	QMouseEvent*	event
    );
    
    void MouseRelease();
    
    void Paint
    (
	QWidget*	widget
    );
    
    void Resize
    (
	QWidget*	widget
    );
    

protected: // Methods

    void mousePressEvent
    ( 
	QMouseEvent*	event 
    );

    void mouseMoveEvent
    (
	QMouseEvent*	event
    );

    void mouseReleaseEvent
    (
	QMouseEvent*	//event
    );
        
    void paintEvent( QPaintEvent * );

    void resizeEvent
    (
	QResizeEvent*	//event
    );

private: // Attributes
	int actGrid;
  // The grid of the Layouter

    QPopupMenu*	itsMenu;
    // popup menu 

};


inline int WidgetFrame::GetGrid() const
{
    return actGrid;
}


#endif


