#include <qapp.h>
// $Id: main.cpp,v 1.2 1997/04/17 03:19:51 jharris Exp $
#include <qfont.h>
#include <qregexp.h>
#include <qstring.h>

#include <stdlib.h>
#include <stdio.h>

#include "ProjectWnd.h"

int main( int argc, char** argv )
{
    QApplication a( argc, argv );

    QFont font( "helvetica", 12 );
    font.setStyleHint( QFont::Helvetica );
    a.setFont( font, TRUE );

    ProjectWnd* wnd = new ProjectWnd;

    a.setMainWidget( wnd );

  // Remove TMPDIR from environment
  QString envTmpDir = getenv( "TMPDIR" );
  putenv( "TMPDIR" );

  QString tempDir = getenv( "DLGEDIT" );

  if( tempDir.isEmpty() )
    tempDir = "/tmp";

  char *tmpName = tempnam( tempDir, "dlg" );
  wnd->SetTempFile( tmpName ); 

  // Reinsert TMPDIR
  if( ! envTmpDir.isEmpty() )
  {
    envTmpDir = "TMPDIR=" + envTmpDir;
    putenv( envTmpDir );
  }

    if( a.argc() > 1 )
    {
	if( QString(a.argv()[1]) == "-g" )
	{
	    wnd->AutoGenerate();
	}
	else // load dialogs on command line
	{
	    wnd->show();

      for( int i = 1; i < a.argc(); i++ )
        wnd->ObjectLoad( a.argv()[i] );
	}
    }
    else
    {
	wnd->show();
    }

  int retVal = a.exec();

  // Clean up
  remove( tmpName );

  free( tmpName );

  return retVal;
}


