#include "DialogBasePage.h"

#include "Dialog.h"
#include "DialogWnd.h"

#define Inherited DialogBasePageData

DialogBasePage::DialogBasePage
(
    Dialog* dialog,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    switch( dialog->GetWindowType() )
    {
	case Dialog::WT_Dialog:
	{
	    isQDialog->setChecked( TRUE );
	    break;
	}
	case Dialog::WT_TabDialog:
	{
	    isQTabDialog->setChecked( TRUE );
	    break;
	}
	case Dialog::WT_Widget:
	{
	    isQWidget->setChecked( TRUE );
	    break;
	}
	case Dialog::WT_Frame:
	{
	    isQFrame->setChecked( TRUE );
	    break;
	}
    }
    
    isModalDialog->setChecked( dialog->IsDialogModal() );
}


DialogBasePage::~DialogBasePage()
{
}


void DialogBasePage::Apply( Dialog* dialog )
{
    Dialog::WindowType type = Dialog::WT_Dialog;
    
    if( isQTabDialog->isChecked() )
    {
	type = Dialog::WT_TabDialog;
    }
    else if( isQWidget->isChecked() )
    {
	type = Dialog::WT_Widget;
    }
    else if( isQFrame->isChecked() )
    {
	type = Dialog::WT_Frame;
    }
    
    dialog->SetWindowType( type );
    
    dialog->SetIsDialogModal( isModalDialog->isChecked() );
}
