#include "DialogGenPage.h"

#include "Dialog.h"

#define Inherited DialogGenPageData

DialogGenPage::DialogGenPage
(
    Dialog* dialog,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name ),
    canModClassFiles( TRUE ),
    canModDataName( TRUE ),
    canModDataFiles( TRUE )
{
    itsClassName->setText( dialog->GetClassName() );
    itsClassHeader->setText( dialog->GetClassHeader() );
    itsClassSource->setText( dialog->GetClassSource() );
    itsDataName->setText( dialog->GetDataName() );
    itsDataHeader->setText( dialog->GetDataHeader() );
    itsDataSource->setText( dialog->GetDataSource() );
    
    connect( itsClassName, SIGNAL(textChanged(const char*)),
	     SLOT(ClassNameChanged(const char*)) );
    connect( itsClassHeader, SIGNAL(textChanged(const char*)),
	     SLOT(ClassFilesKeyPressed(const char*)) );
    connect( itsClassSource, SIGNAL(textChanged(const char*)),
	     SLOT(ClassFilesKeyPressed(const char*)) );
    connect( itsDataName, SIGNAL(textChanged(const char*)),
	     SLOT(DataNameChanged(const char*)) );
    connect( itsDataHeader, SIGNAL(textChanged(const char*)),
	     SLOT(DataFilesKeyPressed(const char*)) );
    connect( itsDataSource, SIGNAL(textChanged(const char*)),
	     SLOT(DataFilesKeyPressed(const char*)) );

}


DialogGenPage::~DialogGenPage()
{
}


void DialogGenPage::Apply( Dialog* dialog )
{
    dialog->SetClassName( itsClassName->text() );
    dialog->SetClassHeader( itsClassHeader->text() );
    dialog->SetClassSource( itsClassSource->text() );
    dialog->SetDataName( itsDataName->text() );
    dialog->SetDataHeader( itsDataHeader->text() );
    dialog->SetDataSource( itsDataSource->text() );
}


void DialogGenPage::ClassNameChanged( const char* text )
{
    QString str = text;
    
    if( canModClassFiles )
    {
	itsClassHeader->setText( str + ".h" );
	itsClassSource->setText( str + ".cpp" );
    }
    
    if( canModDataName )
    {
	itsDataName->setText( str + "Data" );
    }
}


void DialogGenPage::ClassFilesKeyPressed( const char* )
{
    QString header = itsClassName->text();
    header += ".h";
    
    QString source = itsClassName->text();
    source += ".cpp";
    
    canModClassFiles = ( (header == itsClassHeader->text()) &&
			 (source == itsClassSource->text()) );
}


void DialogGenPage::DataNameChanged( const char* text )
{
    QString str = itsClassName->text();
    str += "Data";
    
    canModDataName = (str == text);

    if( canModDataFiles )
    {
	str = text;
	
	itsDataHeader->setText( str + ".h" );
	itsDataSource->setText( str + ".cpp" );
    }
}


void DialogGenPage::DataFilesKeyPressed( const char* )
{
    QString header = itsDataName->text();
    header += ".h";
    
    QString source = itsDataName->text();
    source += ".cpp";
    
    canModDataFiles = ( (header == itsDataHeader->text()) &&
			(source == itsDataSource->text()) );
}

