#include "DialogPropDialog.h"

#include "DialogWnd.h"

#define Inherited DialogPropDialogData

DialogPropDialog::DialogPropDialog
(
    Dialog* dialog,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name ),
    itsBasePage( dialog, this ),
    itsGenPage( dialog, this ),
    itsWindowPage( dialog, this ),
    itsDialog( dialog )
{
    setCaption( "Window Properties" );

    addTab( &itsBasePage, "Base class" );
    addTab( &itsGenPage, "File Generation" );
    addTab( &itsWindowPage, "Window" );
    
    setCancelButton();
    
    connect( this, SIGNAL(applyButtonPressed()), SLOT(Apply()) );
}


DialogPropDialog::~DialogPropDialog()
{
}


void DialogPropDialog::Apply()
{
    itsBasePage.Apply( itsDialog );
    itsGenPage.Apply( itsDialog );
    itsWindowPage.Apply( itsDialog );
}
