#include <qstring.h>

#include "WidgetPropDialog.h"

#include "prop/WidgetVarMapPage.h"
#include "prop/WidgetCommonPage.h"
#include "prop/WidgetColorPage.h"

#define Inherited WidgetPropDialogData

WidgetPropDialog::WidgetPropDialog
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name ),
    itsDlgWidget( widget )
{
    QString str = "Widget Properties - ";
    str += widget->GetWidget()->name();
    setCaption( str );

    itsVarMapPage = new WidgetVarMapPage( widget, this );
    itsCommonPage = new WidgetCommonPage( widget, this );
    itsColorPage = new WidgetColorPage( widget, this );    

    addTab( itsVarMapPage, "Variable Mapping" );
    addTab( itsCommonPage, "Widget" );
    addTab( itsColorPage, "Colors & Font" );

    setCancelButton();
    setApplyButton();

    connect( this, SIGNAL(applyButtonPressed()), SLOT(Apply()) );
}


WidgetPropDialog::~WidgetPropDialog()
{
}


void WidgetPropDialog::Apply()
{
    itsVarMapPage->Apply( itsDlgWidget );
    itsCommonPage->Apply( itsDlgWidget );
    itsColorPage->Apply( itsDlgWidget );

    itsDlgWidget->GetWidget()->repaint();
}
