#include "widget/CheckBox.h"

#define Inherited QCheckBox

CheckBox::CheckBox
(
    QWidget*		widget,
    const char*		name
)
    :
    Inherited( widget, name )
{
}


void CheckBox::mousePressEvent
(
    QMouseEvent*	event
)
{
    emit MousePress( this, event );	
    //Inherited::mousePressEvent( event );
    
}


void CheckBox::mouseMoveEvent
(
    QMouseEvent*	event
)
{
    emit MouseMove( this, event );
    //Inherited::mouseMoveEvent( event );
    
}


void CheckBox::mouseReleaseEvent
(
    QMouseEvent*	 //event
)
{
    emit MouseRelease();
    //Inherited::mouseReleaseEvent( event );
    
}


void CheckBox::paintEvent
(
    QPaintEvent*	event
)
{
    Inherited::paintEvent( event );
    
    emit Paint( this );
}


void CheckBox::resizeEvent
(
    QResizeEvent*	event
)
{
    Inherited::resizeEvent( event );
    
    emit Resize( this );
}




