#include "widget/DlgButton.h"

#include "prop/ButtonPropDialog.h"

#include "GuiTools.h"

#define Inherited DlgWidget

QStrList DlgButton::itsSignals;
int DlgButton::itsNextWidgetNum = 1;

DlgButton::DlgButton
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_Button )
{
    itsWidget = new Button( parent, 	
			    CreateName( "Button", name, itsNextWidgetNum ) );

    itsWidget->setMinimumSize( 10, 10 );

}

DlgButton::~DlgButton()
{
    // itsWidget destroyed when its parent is destroyed
}

int DlgButton::DoPropertyDialog( QWidget *parent, char *name )
{
    ButtonPropDialog dlg( this, parent, name );
    int ret = dlg.exec();

    // Repaint is neccesary because theDialog may have changed this...
    itsWidget->repaint();

    return ret;
}



void DlgButton::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nButton {";
  
    DlgButton::SaveQt( stream, (const QButton *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgButton::SaveQt
(
   QTextStream &stream,
   const QButton *widget
)
{
    stream << "\n\t\tText {" << widget->text() << "}";

    stream << "\n\t\tAutoRepeat {";
    SaveBool( stream, widget->autoRepeat() );
    stream << "}";
    
    stream << "\n\t\tAutoResize {";
    SaveBool( stream, widget->autoResize() );
    stream << "}";
}

bool DlgButton::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( ! DlgButton::RestoreQt( key, value, (QButton *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgButton::RestoreQt
(
   const QString &key,
   const QString &value,
   QButton *widget
)
{
  // Compare to known keys
    if( key == "Text" )
    {
	widget->setText( value );
    } 
    else if( key == "AutoRepeat" )
    {
	widget->setAutoRepeat( (value == "TRUE") );
    }
    else if( key == "AutoResize" )
    {
	widget->setAutoResize( (value == "TRUE") );
    }
    else
    {
	// Key unknown
	return FALSE;
    }
    return TRUE;
}  


void DlgButton::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgWidget::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QButton* widget = (const QButton*)dlgWidget.GetWidget();

    stream << varName << "setText( \"" << widget->text() << "\" );\n";
    stream << varName << "setAutoRepeat( " << 
	(widget->autoRepeat() ? "TRUE" : "FALSE") << " );\n";
    stream << varName << "setAutoResize( " <<
	(widget->autoResize() ? "TRUE" : "FALSE") << " );\n";
}


void DlgButton::AddSignalsToList( QStrList&	signalList ) const
{
    Inherited::AddSignalsToList( signalList );
    GuiTools::QStrListAppendAll( signalList, GetSignalList() );
}


const QStrList& DlgButton::GetSignalList( void )
{
    if( itsSignals.isEmpty() )
    {
	itsSignals.append( "pressed()" );
	itsSignals.append( "released()" );
	itsSignals.append( "clicked()" );
	itsSignals.append( "toggled(bool)" );
    }

    return itsSignals;
}
