#ifndef DlgButton_included
#define DlgButton_included

#include <qstring.h>
#include <qstrlist.h>

#include "widget/DlgWidget.h"
#include "widget/Button.h"

class DlgButton : public DlgWidget
{

public:

    DlgButton
    (
	QWidget*	parentWidget,
	const char*	name = NULL
    );

    virtual ~DlgButton();
    
    virtual QWidget* GetWidget( void );
    // return the DlgButton's widget

    virtual int DoPropertyDialog( QWidget *, char * );
    // Do the property dialog

    virtual void SaveContents
    (
	QTextStream&	stream
    );
    // save the contents of the widget

    static void SaveQt
    (
       QTextStream &,
       const QButton *
    );
    // Used by original Qt subclasses

    static bool RestoreQt
    (
       const QString &,
       const QString &,
       QButton *
    );
    // Used by original Qt subclasses

    virtual bool RestoreKeyValue( QString &key, QString &value );
    // Restore a single key/value pair

    virtual QString GetHeaderFilename() const;
    // return the header filename for the widget

    virtual QString GetWidgetClass() const;
    // return the class name for the widget

    virtual void GenerateSource
    (
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // call GenSrc for the appropriate widget base classes. varName already
    // has a leading tab and the correct dereferencer

    static void GenSrc
    (
	DlgWidget&		dlgWidget,
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // static method to actually generate the source

    virtual void AddSignalsToList( QStrList&	signalList ) const;
    // add signals specific to a particular widget type to the list

    static const QStrList& GetSignalList( void );
    // method to return the list of signals

private: // static data

    static QStrList	itsSignals;
    // list of the signals that can be connected to this widget

private:

    Button*	itsWidget;

    static int itsNextWidgetNum;
    // number of the next widget

};


inline QWidget* DlgButton::GetWidget( void )
{
    return itsWidget;
}


inline QString DlgButton::GetHeaderFilename() const
{
    return "<qbutton.h>";
}

inline QString DlgButton::GetWidgetClass() const
{
    return "QButton";
}

inline void DlgButton::GenerateSource
(
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    GenSrc( *this, stream, varName, zOrdering );
}

#endif // DlgButton_included
