#include <qmsgbox.h>

#include "widget/DlgButtonGroup.h"
#include "widget/DlgGroupBox.h"

#include "prop/ButtonGroupPropDialog.h"

#include "GuiTools.h"

#define Inherited DlgWidget

QStrList DlgButtonGroup::itsSignals;
int DlgButtonGroup::itsNextWidgetNum = 1;

DlgButtonGroup::DlgButtonGroup
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_ButtonGroup )
{
    itsWidget = new ButtonGroup( parent, CreateName( "ButtonGroup", name, 
						     itsNextWidgetNum ));
    itsWidget->setMinimumSize( 10, 10 );

}

DlgButtonGroup::~DlgButtonGroup()
{
    // itsWidget deleted when its parent is deleted
}

int DlgButtonGroup::DoPropertyDialog( QWidget *parent, char *name )
{
    ButtonGroupPropDialog dlg( this, parent, name );
    int ret = dlg.exec();
    
    // Repaint is neccesary because theDialog may have changed this...
    itsWidget->repaint();

    return ret;
}


void DlgButtonGroup::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nButtonGroup {";
  
    DlgButtonGroup::SaveQt( stream, (const QButtonGroup *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgButtonGroup::SaveQt
(
   QTextStream &stream,
   const QButtonGroup *widget
)
{
  if( widget->isExclusive() )
  stream << "\n\t\tExclusive {" << widget->isExclusive() << "}";
  DlgGroupBox::SaveQt( stream, (const QGroupBox *) widget );
}

bool DlgButtonGroup::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( ! DlgButtonGroup::RestoreQt( key, value, (QButtonGroup *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgButtonGroup::RestoreQt
(
   const QString &key,
   const QString &value,
   QButtonGroup *widget
)
{
  // Compare to known keys
  if( key == "Exclusive" )
  {
    if( value == "TRUE" )
      widget->setExclusive( TRUE );
    else
      widget->setExclusive( FALSE );
  } else
  {
    // Key unknown
    return DlgGroupBox::RestoreQt( key, value, (QGroupBox *) widget );
  }
  return TRUE;
}  


void DlgButtonGroup::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgGroupBox::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QButtonGroup* widget = (const QButtonGroup*)dlgWidget.GetWidget();
    QRect groupRect = widget->geometry();
    QListIterator<DlgWidget> iter( zOrdering );
    DlgWidget* listWidget;

    while( (listWidget = iter()) )
    {
	DlgWidget::Type type = listWidget->GetType();

	// if the widget is contained inside the group and is derived from
	// a QButton
	if( (groupRect.contains( listWidget->GetWidget()->geometry() )) &&
	    ( (type == DW_Button) || (type == DW_CheckBox) || 
	      (type == DW_PushButton) || (type == DW_RadioButton) ) )
	{
	    if( !listWidget->GetVariableName().isEmpty() )
	    {
		stream << varName << "insert( " << 
		    listWidget->GetVariableName() << " );\n";
	    }	
	    else
	    {
		QString msg = "The button \"" + 
		    QString(listWidget->GetWidget()->name()) +
		    "\" must be mapped to a variable before \n"
		    "insertion into a QButtonGroup will work.";
		QMessageBox::message( "Qt Dialog Editor", msg );
	    } 				      
	}
    }

    stream << varName <<"lower();\n";

    if( widget->isExclusive() )
    {
	stream << varName << "setExclusive( TRUE );\n";
    }
}


void DlgButtonGroup::AddSignalsToList( QStrList&	signalList ) const
{
    Inherited::AddSignalsToList( signalList );
    GuiTools::QStrListAppendAll( signalList, GetSignalList() );
}


const QStrList& DlgButtonGroup::GetSignalList( void )
{
    if( itsSignals.isEmpty() )
    {
	itsSignals.append( "pressed(int)" );
	itsSignals.append( "released(int)" );
	itsSignals.append( "clicked(int)" );
    }

    return itsSignals;
}
