#ifndef DlgCheckBox_included
#define DlgCheckBox_included

#include <qstring.h>
#include <qstrlist.h>

#include "widget/DlgWidget.h"
#include "widget/CheckBox.h"

class DlgCheckBox : public DlgWidget
{

public:

    DlgCheckBox
    (
	QWidget*	parentWidget,
	const char*	name = NULL
    );

    virtual ~DlgCheckBox();
    
    virtual QWidget* GetWidget( void );
    // return the DlgCheckBox's widget

    virtual int DoPropertyDialog( QWidget *, char * );
    // Do the property dialog

    virtual void SaveContents
    (
	QTextStream&	stream
    );
    // save the contents of the widget

    static void SaveQt
    (
       QTextStream &,
       const QCheckBox *
    );
    // Used by original Qt subclasses

    static bool RestoreQt
    (
       const QString &,
       const QString &,
       QCheckBox *
    );
    // Used by original Qt subclasses

    virtual bool RestoreKeyValue( QString &key, QString &value );
    // Restore a single key/value pair

    virtual QString GetHeaderFilename() const;
    // return the header filename for the widget

    virtual QString GetWidgetClass() const;
    // return the class name for the widget

    virtual void GenerateSource
    (
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // call GenSrc for the appropriate widget base classes. varName already
    // has a leading tab and the correct dereferencer

    static void GenSrc
    (
	DlgWidget&		dlgWidget,
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // static method to actually generate the source

    virtual void AddSignalsToList( QStrList&	signalList ) const;
    // add signals specific to a particular widget type to the list
    
private:

    CheckBox*	itsWidget;

    static int itsNextWidgetNum;
    // number of the next widget

};


inline QWidget* DlgCheckBox::GetWidget( void )
{
    return itsWidget;
}


inline QString DlgCheckBox::GetHeaderFilename() const
{
    return "<qchkbox.h>";
}

inline QString DlgCheckBox::GetWidgetClass() const
{
    return "QCheckBox";
}

inline void DlgCheckBox::GenerateSource
(
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    GenSrc( *this, stream, varName, zOrdering );
}

#endif // DlgCheckBox_included
