#include "widget/DlgComboBox.h"

#include "prop/ComboBoxPropDialog.h"

#include "GuiTools.h"

#define Inherited DlgWidget

QStrList DlgComboBox::itsSignals;
int DlgComboBox::itsNextWidgetNum = 1;

DlgComboBox::DlgComboBox
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_ComboBox ),
    itsComboType( CT_ReadOnly )
{
    itsWidget = new ComboBox( parent, CreateName( "ComboBox", name, 
						  itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgComboBox::~DlgComboBox()
{
}

int DlgComboBox::DoPropertyDialog( QWidget *parent, char *name )
{
    ComboBoxPropDialog dlg( this, parent, name );
    int ret = dlg.exec();
    
    // Repaint is neccesary because theDialog may have changed this...
    itsWidget->repaint();

    return ret;
}


void DlgComboBox::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nComboBox {";

    // save DlgComboBox specific info
    stream << "\n\t\tStyle {";
    switch( itsComboType )
    {
	case CT_ReadOnly:
	default:
	{
	    stream << "ReadOnly";
	    break;
	}
	case CT_ReadWrite:
	{
	    stream << "ReadWrite";
	    break;
	}
	case CT_Motif1x:
	{
	    stream << "Motif1x";
	    break;
	}
    }
    stream << "}";
    
    DlgComboBox::SaveQt( stream, (const QComboBox *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgComboBox::SaveQt
(
   QTextStream &stream,
   const QComboBox *widget
)
{
    stream << "\n\t\tSizeLimit {" << widget->sizeLimit() << "}";

    stream << "\n\t\tPolicy {";
    switch( widget->insertionPolicy() )
    {
	case QComboBox::NoInsertion:
	{
	    stream << "NoInsertion";
	    break;
	}
	case QComboBox::AtTop:
	{
	    stream << "AtTop";
	    break;
	}
	case QComboBox::AtCurrent:
	{
	    stream << "AtCurrent";
	    break;
	}
	case QComboBox::AtBottom:
	{
	    stream << "AtBottom";
	    break;
	}
	case QComboBox::AfterCurrent:
	{
	    stream << "AfterCurrent";
	    break;
	}
	case QComboBox::BeforeCurrent:
	{
	    stream << "BeforeCurrent";
	    break;
	}
    }
    stream << "}";

    stream << "\n\t\tAutoResize {";
    SaveBool( stream, widget->autoResize() );
    stream << "}";

    for( int i = 0; i < widget->count(); i++ )
	stream << "\n\t\tItem {" << widget->text( i ) << "}";
}

bool DlgComboBox::RestoreKeyValue( QString &key, QString &value )
{
    bool retVal = TRUE;

    if( ! DlgComboBox::RestoreQt( key, value, (QComboBox *) itsWidget ) )
    {  
	// restore DlgComboBox specific info
	if( key == "Style" )
	{
	    if( value == "ReadOnly" )
	    {
		itsComboType = CT_ReadOnly;
	    }
	    else if( value == "ReadWrite" )
	    {
		itsComboType = CT_ReadWrite;
	    }
	    else if( value == "Motif1x" )
	    {
		itsComboType = CT_Motif1x;
	    }
	    else
	    {
		retVal = FALSE;
	    }
	}
	else
	{
	    // At last DlgWidget catch the rest
	    retVal = DlgWidget::RestoreKeyValue( key, value );
	}
    }

    return retVal;
}

bool DlgComboBox::RestoreQt
(
   const QString &key,
   const QString &value,
   QComboBox *widget
)
{
    // Compare to known keys
    if( key == "Item" )
    {
	widget->insertItem( value );
    } 
    else if( key == "SizeLimit" )
    {
	widget->setSizeLimit( value.toInt() );
    }
    else if( key == "Policy" )
    {
	if( value == "NoInsertion" )
	{
	    widget->setInsertionPolicy( QComboBox::NoInsertion );
	}
	else if( value == "AtTop" )
	{
	    widget->setInsertionPolicy( QComboBox::AtTop );
	}
	else if( value == "AtCurrent" )
	{
	    widget->setInsertionPolicy( QComboBox::AtCurrent );
	}
	else if( value == "AtBottom" )
	{
	    widget->setInsertionPolicy( QComboBox::AtBottom );
	}
	else if( value == "AfterCurrent" )
	{
	    widget->setInsertionPolicy( QComboBox::AfterCurrent );
	}
	else if( value == "BeforeCurrent" )
	{
	    widget->setInsertionPolicy( QComboBox::BeforeCurrent );
	}
	else
	{
	    return FALSE;
	}
    }
    else if( key == "AutoResize" )
    {
	widget->setAutoResize( (value == "TRUE") );
    }
    else
    {
	// Key unknown
	return FALSE;
    }

    return TRUE;
}  


void DlgComboBox::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgWidget::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QComboBox* widget = (const QComboBox*)dlgWidget.GetWidget();
    const DlgComboBox& dlgCombo = (const DlgComboBox&)dlgWidget;
    int i;

    switch( dlgCombo.GetComboType() )
    {
	case CT_ReadWrite:
	{
	    stream << varName << "setInsertionPolicy( QComboBox::";
	    switch( widget->insertionPolicy() )
	    {
		case QComboBox::NoInsertion:
		{
		    stream << "NoInsertion";
		    break;
		}
		case QComboBox::AtTop:
		{
		    stream << "AtTop";
		    break;
		}
		case QComboBox::AtCurrent:
		{
		    stream << "AtCurrent";
		    break;
		}
		case QComboBox::AtBottom:
		{
		    stream << "AtBottom";
		    break;
		}
		case QComboBox::AfterCurrent:
		{
		    stream << "AfterCurrent";
		    break;
		}
		case QComboBox::BeforeCurrent:
		{
		    stream << "BeforeCurrent";
		    break;
		}
	    }
	    stream << " );\n";
	    
	    // fall through
	}
	case CT_ReadOnly:
	{
	    stream << varName << "setSizeLimit( " << widget->sizeLimit() <<
		" );\n";
	    break;
	}
	case CT_Motif1x:
	{
	    break; // do nothing
	}
    }

    stream << varName << "setAutoResize( " <<
	(widget->autoResize() ? "TRUE" : "FALSE") << " );\n";
    
    for( i = 0; i < widget->count(); i++ )
    {
	stream << varName << "insertItem( \"" << widget->text( i ) <<
	    "\" );\n";
    }
}


void DlgComboBox::GenerateCtor
(
    QTextStream&	stream,
    const QString&	varName
)
{
    QString name;
    const char* cp = GetWidget()->name();
    if( cp )
    {
	name = "\"";
	name += cp;
	name += "\"";
    }
    else
    {
	name = "NULL";
    }

    stream << '\t' << varName << " = new " << GetWidgetClass() << "( ";

    switch( itsComboType )
    {
	case CT_ReadOnly:
	{
	    stream << "FALSE, ";
	    break;
	}
	case CT_ReadWrite:
	{
	    stream << "TRUE, ";
	    break;
	}
	case CT_Motif1x:
	{
	    break; // do nothing
	}
    }

    stream << "this, " << name << " );\n";
}


void DlgComboBox::AddSignalsToList( QStrList&	signalList ) const
{
    Inherited::AddSignalsToList( signalList );
    GuiTools::QStrListAppendAll( signalList, GetSignalList() );
}


const QStrList& DlgComboBox::GetSignalList( void )
{
    if( itsSignals.isEmpty() )
    {
	itsSignals.append( "activated(int)" );
	itsSignals.append( "activated(const char*)" );
	itsSignals.append( "highlighted(int)" );
	itsSignals.append( "highlighted(const char*)" );
    }

    return itsSignals;
}
