#ifndef DlgFrame_included
#define DlgFrame_included

#include <qstring.h>

#include "widget/DlgWidget.h"
#include "widget/Frame.h"

class DlgFrame : public DlgWidget
{

public:

    DlgFrame
    (
	QWidget*	parentWidget,
	const char*	name = NULL
    );

    virtual ~DlgFrame();
    
    virtual QWidget* GetWidget( void );
    // return the DlgFrame's widget

    virtual int DoPropertyDialog( QWidget *, char * );
    // Do the property dialog

    virtual void SaveContents
    (
	QTextStream&	stream
    );
    // save the contents of the widget

    static void SaveQt
    (
       QTextStream &,
       const QFrame *
    );
    // Used by original Qt subclasses

    static bool RestoreQt
    (
       const QString &,
       const QString &,
       QFrame *
    );
    // Used by original Qt subclasses

    virtual bool RestoreKeyValue( QString &key, QString &value );
    // Restore a single key/value pair

    virtual QString GetHeaderFilename() const;
    // return the header filename for the widget

    virtual QString GetWidgetClass() const;
    // return the class name for the widget

    virtual void GenerateSource
    (
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // call GenSrc for the appropriate widget base classes

    static void GenSrc
    (
	DlgWidget&		dlgWidget,
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // static method to actually generate the source

private:

    Frame*	itsWidget;

    static int itsNextWidgetNum;
    // number of the next widget

};


inline QWidget* DlgFrame::GetWidget( void )
{
    return itsWidget;
}


inline QString DlgFrame::GetHeaderFilename() const
{
    return "<qframe.h>";
}

inline QString DlgFrame::GetWidgetClass() const
{
    return "QFrame";
}

inline void DlgFrame::GenerateSource
(
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    GenSrc( *this, stream, varName, zOrdering );
}


#endif // DlgFrame_included
