#include "widget/DlgGroupBox.h"
#include "widget/DlgFrame.h"

#include "prop/GroupBoxPropDialog.h"

#define Inherited DlgWidget

int DlgGroupBox::itsNextWidgetNum = 1;

DlgGroupBox::DlgGroupBox
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_GroupBox )
{
    itsWidget = new GroupBox( parent, CreateName( "GroupBox", name, 
						  itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgGroupBox::~DlgGroupBox()
{
}

int DlgGroupBox::DoPropertyDialog( QWidget *parent, char *name )
{
    GroupBoxPropDialog dlg( this, parent, name );
    int ret = dlg.exec();
    
    // Repaint is neccesary because theDialog may have changed this...
    itsWidget->repaint();

    return ret;
}


void DlgGroupBox::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nGroupBox {";
  
    DlgGroupBox::SaveQt( stream, (const QGroupBox *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgGroupBox::SaveQt
(
   QTextStream &stream,
   const QGroupBox *widget
 )
{
  stream << "\n\t\tTitle {" << widget->title() << "}";

  int align = widget->alignment();
  if( align != AlignHCenter )
  {
  QString alignStr;
  
  if( align == AlignLeft )
    alignStr = "Left";
  else
    alignStr = "Right";

  stream << "\n\t\tAlignment {" << alignStr << "}";
  }

  DlgFrame::SaveQt( stream, (const QFrame *) widget );
}

bool DlgGroupBox::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( ! DlgGroupBox::RestoreQt( key, value, (QGroupBox *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgGroupBox::RestoreQt
(
   const QString &key,
   const QString &value,
   QGroupBox *widget
)
{
  // Compare to known keys
  if( key == "Title" )
  {
    widget->setTitle( value );
  } else if( key == "Alignment" )
  {
    int align;

    if( value == "Left" )
      align = AlignLeft;
    else if( value == "Center" )
      align = AlignCenter;
    else
      align = AlignRight;
    
    widget->setAlignment( align );
  } else
  {
    // Key unknown
    return DlgFrame::RestoreQt( key, value, (QFrame *) widget );
  }
  return TRUE;
}  


void DlgGroupBox::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgFrame::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QGroupBox* widget = (const QGroupBox*)dlgWidget.GetWidget();

    if( widget->title() )
    {
	stream << varName << "setTitle( \"" << widget->title() << "\" );\n";
    }
    
    if( widget->alignment() != AlignHCenter )
    {
	stream << varName << "setAlignment( " << widget->alignment() << 
	    " );\n";
    }
}



