#ifndef DlgGroupBox_included
#define DlgGroupBox_included

#include <qstring.h>

#include "widget/DlgWidget.h"
#include "widget/GroupBox.h"

class DlgGroupBox : public DlgWidget
{

public:

    DlgGroupBox
    (
	QWidget*	parentWidget,
	const char*	name = NULL
    );

    virtual ~DlgGroupBox();
    
    virtual QWidget* GetWidget( void );
    // return the DlgGroupBox's widget

    virtual int DoPropertyDialog( QWidget *, char * );
    // Do the property dialog

    virtual void SaveContents
    (
	QTextStream&	stream
    );
    // save the contents of the widget

    static void SaveQt
    (
       QTextStream &,
       const QGroupBox *
    );
    // Used by original Qt subclasses

    static bool RestoreQt
    (
       const QString &,
       const QString &,
       QGroupBox *
    );
    // Used by original Qt subclasses

    virtual bool RestoreKeyValue( QString &key, QString &value );
    // Restore a single key/value pair

    virtual QString GetHeaderFilename() const;
    // return the header filename for the widget

    virtual QString GetWidgetClass() const;
    // return the class name for the widget

    virtual void GenerateSource
    (
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // call GenSrc for the appropriate widget base classes. varName already
    // has a leading tab and the correct dereferencer

    static void GenSrc
    (
	DlgWidget&		dlgWidget,
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // static method to actually generate the source

private:

    GroupBox*	itsWidget;

    static int itsNextWidgetNum;
    // number of the next widget

};


inline QWidget* DlgGroupBox::GetWidget( void )
{
    return itsWidget;
}


inline QString DlgGroupBox::GetHeaderFilename() const
{
    return "<qgrpbox.h>";
}

inline QString DlgGroupBox::GetWidgetClass() const
{
    return "QGroupBox";
}

inline void DlgGroupBox::GenerateSource
(
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    GenSrc( *this, stream, varName, zOrdering );
}


#endif // DlgGroupBox_included
