#include "widget/DlgLabel.h"
#include "widget/DlgFrame.h"

#include "prop/LabelPropDialog.h"

#define Inherited DlgWidget

int DlgLabel::itsNextWidgetNum = 1;

DlgLabel::DlgLabel
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_Label )
{
    itsWidget = new Label( parent, CreateName( "Label", name, 
					       itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgLabel::~DlgLabel()
{
}

int DlgLabel::DoPropertyDialog( QWidget *parent, char *name )
{
    LabelPropDialog dlg( this, parent, name );
    int ret = dlg.exec();
    
    // Repaint is neccesary because theDialog may have changed this...
    itsWidget->repaint();

    return ret;
}


void DlgLabel::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nLabel {";
  
    DlgLabel::SaveQt( stream, (const QLabel *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgLabel::SaveQt
(
   QTextStream &stream,
   const QLabel *widget
)
{
    if( widget->text() )
	stream << "\n\t\tText {" << widget->text() << "}";

    QString aStr;

    if( widget->alignment() != (AlignLeft | AlignVCenter | ExpandTabs) )
    {
	aStr.setNum( widget->alignment() );
	stream << "\n\t\tAlignment {" << aStr << "}";
    }

    stream << "\n\t\tAutoResize {";
    SaveBool( stream, widget->autoResize() );
    stream << "}";
    
    stream << "\n\t\tMargin {" << widget->margin() << "}";

    DlgFrame::SaveQt( stream, widget );
}

bool DlgLabel::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( ! DlgLabel::RestoreQt( key, value, (QLabel *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgLabel::RestoreQt
(
   const QString &key,
   const QString &value,
   QLabel *widget
)
{
    // Compare to known keys
    if( key == "Text" )
    {
	widget->setText( value );
    } 
    else if( key == "Alignment" )
    {
	widget->setAlignment( value.toInt() );
    }
    else if( key == "AutoResize" )
    {
	widget->setAutoResize( (value == "TRUE") );
    }
    else if( key == "Margin" )
    {
	widget->setMargin( value.toInt() );
    }
    else
    {
	// Key unknown
	return DlgFrame::RestoreQt( key, value, widget );
    }
    return TRUE;
}  


void DlgLabel::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgFrame::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QLabel* widget = (const QLabel*)dlgWidget.GetWidget();

    if( widget->text() )
    {
	stream << varName << "setText( \"" << widget->text() << "\" );\n";
    }
    
    stream << varName << "setAlignment( " << widget->alignment() << " );\n";

    stream << varName << "setMargin( " << widget->margin() << " );\n";
}



