#include "widget/DlgLineEdit.h"
#include "widget/DlgFrame.h"

#include "prop/LineEditPropDialog.h"

#include "GuiTools.h"

#define Inherited DlgWidget

QStrList DlgLineEdit::itsSignals;
int DlgLineEdit::itsNextWidgetNum = 1;

DlgLineEdit::DlgLineEdit
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_LineEdit )
{
    itsWidget = new LineEdit( parent, CreateName( "LineEdit", name, 
						  itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgLineEdit::~DlgLineEdit()
{
}

int DlgLineEdit::DoPropertyDialog( QWidget *parent, char *name )
{
    LineEditPropDialog dlg( this, parent, name );
    int ret = dlg.exec();
    
    // Repaint is neccesary because theDialog may have changed this...
    itsWidget->repaint();

    return ret;
}


void DlgLineEdit::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nLineEdit {";
  
    DlgLineEdit::SaveQt( stream, (const QLineEdit *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgLineEdit::SaveQt
(
   QTextStream &stream,
   const QLineEdit *widget
 )
{
    stream << "\n\t\tText {" << widget->text() << "}";

    stream << "\n\t\tEchoMode {" << 
	GuiTools::QLineEditEchoModeStr( widget->echoMode() ) << "}";

    QString aStr;
    aStr.setNum( widget->maxLength() );
    stream << "\n\t\tMaxLength {" << aStr << "}";

    stream << "\n\t\tFrameShown {";
    SaveBool( stream, widget->frame() );
    stream << "}";
}

bool DlgLineEdit::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( ! DlgLineEdit::RestoreQt( key, value, (QLineEdit *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgLineEdit::RestoreQt
(
   const QString &key,
   const QString &value,
   QLineEdit *widget
)
{
    // Compare to known keys
    if( key == "Text" )
    {
	widget->setText( value );
    } 
    else if( key == "MaxLength" )
    {
	widget->setMaxLength( value.toInt() );
    }
    else if( key == "EchoMode" )
    {
	widget->setEchoMode( GuiTools::QLineEditEchoMode( value ) );
    }
    else if( key == "FrameShown" )
    {
	widget->setFrame( (value == "TRUE") );
    }
    else
    {
	// Key unknown
	return FALSE;
    }
    return TRUE;
}  


void DlgLineEdit::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgWidget::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QLineEdit* widget = (const QLineEdit*)dlgWidget.GetWidget();

    if( widget->text() )
    {
	stream << varName << "setText( \"" << widget->text() << "\" );\n";
    }
    
    stream << varName << "setMaxLength( " << widget->maxLength() << " );\n";

    stream << varName << "setEchoMode( QLineEdit::" <<
	GuiTools::QLineEditEchoModeStr( widget->echoMode() ) << " );\n";
    
    stream << varName << "setFrame( " <<
	(widget->frame() ? "TRUE" : "FALSE") << " );\n";
}


void DlgLineEdit::AddSignalsToList( QStrList&	signalList ) const
{
    Inherited::AddSignalsToList( signalList );
    GuiTools::QStrListAppendAll( signalList, GetSignalList() );
}


const QStrList& DlgLineEdit::GetSignalList( void )
{
    if( itsSignals.isEmpty() )
    {
	itsSignals.append( "textChanged(const char*)" );
	itsSignals.append( "returnPressed()" );
    }

    return itsSignals;
}
