#include "widget/DlgListBox.h"
#include "widget/DlgFrame.h"

#include "prop/ListBoxPropDialog.h"

#include "GuiTools.h"

#define Inherited DlgWidget

QStrList DlgListBox::itsSignals;
int DlgListBox::itsNextWidgetNum = 1;

DlgListBox::DlgListBox
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_ListBox )
{
    itsWidget = new ListBox( parent, CreateName( "ListBox", name, 
						 itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgListBox::~DlgListBox()
{
}

int DlgListBox::DoPropertyDialog( QWidget *parent, char *name )
{
    ListBoxPropDialog dlg( this, parent, name );
    int ret = dlg.exec();
    
    // Repaint is neccesary because theDialog may have changed this...
    itsWidget->repaint();

    return ret;
}


void DlgListBox::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nListBox {";
  
    DlgListBox::SaveQt( stream, (const QListBox *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgListBox::SaveQt
(
   QTextStream &stream,
   const QListBox *widget
)
{
  for( unsigned int i = 0; i < widget->count(); i++ )
    stream << "\n\t\tItem {" << widget->text( i ) << "}";

  stream << "\n\t\tDragSelect {";
  SaveBool( stream, widget->dragSelect() );
  stream << "}";
  
  stream << "\n\t\tAutoScroll {";
  SaveBool( stream, widget->autoScroll() );
  stream << "}";
  
  stream << "\n\t\tScrollBar {";
  SaveBool( stream, widget->scrollBar() );
  stream << "}";
  
  stream << "\n\t\tAutoScrollBar {";
  SaveBool( stream, widget->autoScrollBar() );
  stream << "}";
  
  stream << "\n\t\tBottomScrollBar {";
  SaveBool( stream, widget->bottomScrollBar() );
  stream << "}";
  
  stream << "\n\t\tAutoBottomScrollBar {";
  SaveBool( stream, widget->autoBottomScrollBar() );
  stream << "}";
  
  stream << "\n\t\tSmoothScrolling {";
  SaveBool( stream, widget->smoothScrolling() );
  stream << "}";
  
  DlgFrame::SaveQt( stream, widget );
}

bool DlgListBox::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( ! DlgListBox::RestoreQt( key, value, (QListBox *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgListBox::RestoreQt
(
   const QString &key,
   const QString &value,
   QListBox *widget
)
{
  // Compare to known keys
  if( key == "Item" )
  {
    widget->insertItem( value );
  } 
  else if( key == "DragSelect" )
  {
      widget->setDragSelect( (value == "TRUE") );
  }
  else if( key == "AutoScroll" )
  {
      widget->setAutoScroll( (value == "TRUE") );
  }
  else if( key == "ScrollBar" )
  {
      widget->setScrollBar( (value == "TRUE") );
  }
  else if( key == "AutoScrollBar" )
  {
      widget->setAutoScrollBar( (value == "TRUE") );
  }
  else if( key == "BottomScrollBar" )
  {
      widget->setBottomScrollBar( (value == "TRUE") );
  }
  else if( key == "AutoBottomScrollBar" )
  {
      widget->setAutoBottomScrollBar( (value == "TRUE") );
  }
  else if( key == "SmoothScrolling" )
  {
      widget->setSmoothScrolling( (value == "TRUE") );
  }
  else
  {
    // Key unknown
    return DlgFrame::RestoreQt( key, value, widget );
  }
  return TRUE;
}  


void DlgListBox::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgFrame::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QListBox* widget = (const QListBox*)dlgWidget.GetWidget();

    unsigned int i;
    for( i = 0; i < widget->count(); i++ )
    {
	stream << varName << "insertItem( \"" << widget->text( i ) <<
	    "\" );\n";
    }

    if( !widget->dragSelect() )
    {
	stream << varName << "setDragSelect( FALSE );\n";
    }
    
    if( !widget->autoScroll() )
    {
	stream << varName << "setAutoScroll( FALSE );\n";
    }
    
    if( widget->scrollBar() )
    {
	stream << varName << "setScrollBar( TRUE );\n";
    }
    
    if( !widget->autoScrollBar() )
    {
	stream << varName << "setAutoScrollBar( FALSE );\n";
    }
    
    if( widget->bottomScrollBar() )
    {
	stream << varName << "setBottomScrollBar( TRUE );\n";
    }
    
    if( !widget->autoBottomScrollBar() )
    {
	stream << varName << "setAutoBottomScrollBar( FALSE );\n";
    }
    
    if( !widget->smoothScrolling() )
    {
	stream << varName << "setSmoothScrolling( FALSE );\n";
    }
}


void DlgListBox::AddSignalsToList( QStrList&	signalList ) const
{
    Inherited::AddSignalsToList( signalList );
    GuiTools::QStrListAppendAll( signalList, GetSignalList() );
}


const QStrList& DlgListBox::GetSignalList( void )
{
    if( itsSignals.isEmpty() )
    {
	itsSignals.append( "highlighted(int)" );
	itsSignals.append( "selected(int)" );
    }

    return itsSignals;
}
