#include "widget/DlgMenuBar.h"
#include "widget/DlgFrame.h"

#include "prop/MenuBarPropDialog.h"

#include "GuiTools.h"

#define Inherited DlgWidget

QStrList DlgMenuBar::itsSignals;
int DlgMenuBar::itsNextWidgetNum = 1;

DlgMenuBar::DlgMenuBar
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_MenuBar )
{
    itsWidget = new MenuBar( parent, CreateName( "MenuBar", name, 
						 itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgMenuBar::~DlgMenuBar()
{
}

int DlgMenuBar::DoPropertyDialog( QWidget *parent, char *name )
{
    MenuBarPropDialog dlg( this, parent, name );
    int ret = dlg.exec();
    
    // Repaint is neccesary because theDialog may have changed this...
    itsWidget->repaint();

    return ret;
}


void DlgMenuBar::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nMenuBar {";
  
    DlgMenuBar::SaveQt( stream, (const QMenuBar *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgMenuBar::SaveQt
(
    QTextStream &,//stream,
    const QMenuBar *//widget
)
{
  // Nothing to do
}

bool DlgMenuBar::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( ! DlgMenuBar::RestoreQt( key, value, (QMenuBar *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgMenuBar::RestoreQt
(
    const QString &,//key,
    const QString &,//value,
    QMenuBar *//widget
)
{
  // Nothing to do
  return FALSE;
}  


void DlgMenuBar::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgFrame::GenSrc( dlgWidget, stream, varName, zOrdering );
}


void DlgMenuBar::AddSignalsToList( QStrList&	signalList ) const
{
    Inherited::AddSignalsToList( signalList );
    GuiTools::QStrListAppendAll( signalList, GetSignalList() );
}


const QStrList& DlgMenuBar::GetSignalList( void )
{
    if( itsSignals.isEmpty() )
    {
	itsSignals.append( "activated(int)" );
	itsSignals.append( "highlighted(int)" );
    }

    return itsSignals;
}
