#include "widget/DlgMultiLineEdit.h"
#include "widget/DlgFrame.h"

#include "prop/MultiLineEditPropDialog.h"

#include "GuiTools.h"

#define Inherited DlgWidget

QStrList DlgMultiLineEdit::itsSignals;
int DlgMultiLineEdit::itsNextWidgetNum = 1;

DlgMultiLineEdit::DlgMultiLineEdit
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_MultiLineEdit )
{
    itsWidget = new MultiLineEdit( parent, CreateName( "MultiLineEdit", name, 
						       itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgMultiLineEdit::~DlgMultiLineEdit()
{
}

int DlgMultiLineEdit::DoPropertyDialog( QWidget *parent, char *name )
{
    MultiLineEditPropDialog dlg( this, parent, name );
    int ret = dlg.exec();
    
    // Repaint is neccesary because theDialog may have changed this...
    itsWidget->repaint();

    return ret;
}


void DlgMultiLineEdit::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nMultiLineEdit {";
  
    DlgMultiLineEdit::SaveQt( stream, (const QMultiLineEdit *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgMultiLineEdit::SaveQt
(
   QTextStream &stream,
   const QMultiLineEdit *widget
 )
{
    int i;
    for( i = 0; i < widget->numLines(); i++ )
    {
	stream << "\n\t\tLine {" << widget->textLine( i ) << "}";
    }

    stream << "\n\t\tReadOnly {";
    SaveBool( stream, widget->isReadOnly() );
    stream << "}";

    stream << "\n\t\tOverwriteMode {";
    SaveBool( stream, widget->isOverwriteMode() );
    stream << "}";
}

bool DlgMultiLineEdit::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( ! DlgMultiLineEdit::RestoreQt( key, value, (QMultiLineEdit *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgMultiLineEdit::RestoreQt
(
   const QString &key,
   const QString &value,
   QMultiLineEdit *widget
)
{
    // Compare to known keys
    if( key == "Line" )
    {
	widget->insertLine( value );
    }
    else if( key == "ReadOnly" )
    {
	widget->setReadOnly( (value == "TRUE") ? TRUE : FALSE );
    }
    else if( key == "OverwriteMode" )
    {
	widget->setOverwriteMode( (value == "TRUE") );
    }
    else
    {
	// Key unknown
	return FALSE;
    }
    return TRUE;
}  


void DlgMultiLineEdit::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgWidget::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QMultiLineEdit* widget =(const QMultiLineEdit*)dlgWidget.GetWidget();

    int i;
    for( i = 0; i < widget->numLines(); i++ )
    {
	stream << varName << "insertLine( \"" << widget->textLine( i ) <<
	    "\" );\n";
    }

    stream << varName << "setReadOnly( " <<
	(widget->isReadOnly() ? "TRUE" : "FALSE") << " );\n";

    stream << varName << "setOverwriteMode( " <<
	(widget->isOverwriteMode() ? "TRUE" : "FALSE") << " );\n";
}


void DlgMultiLineEdit::AddSignalsToList( QStrList&	signalList ) const
{
    Inherited::AddSignalsToList( signalList );
    GuiTools::QStrListAppendAll( signalList, GetSignalList() );
}


const QStrList& DlgMultiLineEdit::GetSignalList( void )
{
    if( itsSignals.isEmpty() )
    {
	itsSignals.append( "textChanged()" );
	itsSignals.append( "returnPressed()" );
    }

    return itsSignals;
}
