#include "widget/DlgPushButton.h"
#include "widget/DlgButton.h"

#include "prop/PushButtonPropDialog.h"

#include "GuiTools.h"

#define Inherited DlgWidget

int DlgPushButton::itsNextWidgetNum = 1;

DlgPushButton::DlgPushButton
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_PushButton )
{
    itsWidget = new PushButton( parent, CreateName( "PushButton", name, 
						    itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgPushButton::~DlgPushButton()
{
}

int DlgPushButton::DoPropertyDialog( QWidget *parent, char *name )
{
    PushButtonPropDialog dlg( this, parent, name );
    int ret = dlg.exec();
	
    // Repaint is neccesary because theDialog may have changed this...
    itsWidget->repaint();

    return ret;
}


void DlgPushButton::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nPushButton {";
  
    DlgPushButton::SaveQt( stream, (const QPushButton *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgPushButton::SaveQt
(
   QTextStream &stream,
   const QPushButton *widget
)
{
    stream << "\n\t\tToggleButton {";
    SaveBool( stream, widget->isToggleButton() );
    stream << "}";
    
    stream << "\n\t\tDefault {";
    SaveBool( stream, widget->isDefault() );
    stream << "}";
    
    stream << "\n\t\tAutoDefault {";
    SaveBool( stream, widget->autoDefault() );
    stream << "}";

    DlgButton::SaveQt( stream, widget );
}

bool DlgPushButton::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( ! DlgPushButton::RestoreQt( key, value, (QPushButton *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgPushButton::RestoreQt
(
   const QString &key,
   const QString &value,
   QPushButton *widget
)
{
    bool ret = TRUE;
    
    if( key == "ToggleButton" )
    {
	widget->setToggleButton( (value == "TRUE") );
    }
    else if( key == "Default" )
    {
	widget->setDefault( (value == "TRUE" ) );
    }
    else if( key == "AutoDefault" ) 
    {
	widget->setAutoDefault( (value == "TRUE" ) );
    }
    else
    {
	ret = DlgButton::RestoreQt( key, value, widget );
    }
    
    return ret;
}  


void DlgPushButton::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgButton::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QPushButton* widget = (const QPushButton*)dlgWidget.GetWidget();

    if( widget->isToggleButton() )
    {
	stream << varName << "setToggleButton( TRUE );\n";
    }
    
    if( widget->isDefault() )
    {
	stream << varName << "setDefault( TRUE );\n";
    }
    
    if( widget->autoDefault() )
    {
	stream << varName << "setAutoDefault( TRUE );\n";
    }
}


void DlgPushButton::AddSignalsToList( QStrList&	signalList ) const
{
    Inherited::AddSignalsToList( signalList );
    GuiTools::QStrListAppendAll( signalList, DlgButton::GetSignalList() );
}
