#include "widget/DlgRadioButton.h"
#include "widget/DlgButton.h"

#include "prop/RadioButtonPropDialog.h"

#include "GuiTools.h"

#define Inherited DlgWidget

int DlgRadioButton::itsNextWidgetNum = 1;

DlgRadioButton::DlgRadioButton
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_RadioButton )
{
    itsWidget = new RadioButton( parent, CreateName( "RadioButton", name, 
						     itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgRadioButton::~DlgRadioButton()
{
}

int DlgRadioButton::DoPropertyDialog( QWidget *parent, char *name )
{
    RadioButtonPropDialog dlg( this, parent, name );
    int ret = dlg.exec();
    
    // Repaint is neccesary because theDialog may have changed this...
    itsWidget->repaint();

    return ret;
}


void DlgRadioButton::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nRadioButton {";
  
    DlgRadioButton::SaveQt( stream, (const QRadioButton *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgRadioButton::SaveQt
(
   QTextStream &stream,
   const QRadioButton *widget
)
{
    stream << "\n\t\tChecked {";
    SaveBool( stream, widget->isChecked() );
    stream << "}";

    DlgButton::SaveQt( stream, widget );
}

bool DlgRadioButton::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( ! DlgRadioButton::RestoreQt( key, value, (QRadioButton *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgRadioButton::RestoreQt
(
   const QString &key,
   const QString &value,
   QRadioButton *widget
)
{
    bool ret = TRUE;

    if( key == "Checked" )
    {
	widget->setChecked( (value == "TRUE") );
    }
    else
    {
	ret = DlgButton::RestoreQt( key, value, widget );
    }
    
    return ret;
}  


void DlgRadioButton::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgButton::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QRadioButton* button = (const QRadioButton*)dlgWidget.GetWidget();
    
    if( button->isChecked() )
    {
	stream << varName << "setChecked( TRUE );\n";
    }
}


void DlgRadioButton::AddSignalsToList( QStrList&	signalList ) const
{
    Inherited::AddSignalsToList( signalList );
    GuiTools::QStrListAppendAll( signalList, DlgButton::GetSignalList() );
}
