#ifndef DlgRadioButton_included
#define DlgRadioButton_included

#include <qstring.h>

#include "widget/DlgWidget.h"
#include "widget/RadioButton.h"

class DlgRadioButton : public DlgWidget
{

public:

    DlgRadioButton
    (
	QWidget*	parentWidget,
	const char*	name = NULL
    );

    virtual ~DlgRadioButton();
    
    virtual QWidget* GetWidget( void );
    // return the DlgRadioButton's widget

    virtual int DoPropertyDialog( QWidget *, char * );
    // Do the property dialog

    virtual void SaveContents
    (
	QTextStream&	stream
    );
    // save the contents of the widget

    static void SaveQt
    (
       QTextStream &,
       const QRadioButton *
    );
    // Used by original Qt subclasses

    static bool RestoreQt
    (
       const QString &,
       const QString &,
       QRadioButton *
    );
    // Used by original Qt subclasses

    virtual bool RestoreKeyValue( QString &key, QString &value );
    // Restore a single key/value pair

    virtual QString GetHeaderFilename() const;
    // return the header filename for the widget

    virtual QString GetWidgetClass() const;
    // return the class name for the widget

    virtual void GenerateSource
    (
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // call GenSrc for the appropriate widget base classes. varName already
    // has a leading tab and the correct dereferencer

    static void GenSrc
    (
	DlgWidget&		dlgWidget,
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // static method to actually generate the source


    virtual void AddSignalsToList( QStrList&	signalList ) const;
    // add signals specific to a particular widget type to the list

private:

    RadioButton*	itsWidget;

    static int itsNextWidgetNum;
    // number of the next widget

};


inline QWidget* DlgRadioButton::GetWidget( void )
{
    return itsWidget;
}


inline QString DlgRadioButton::GetHeaderFilename() const
{
    return "<qradiobt.h>";
}

inline QString DlgRadioButton::GetWidgetClass() const
{
    return "QRadioButton";
}

inline void DlgRadioButton::GenerateSource
(
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    GenSrc( *this, stream, varName, zOrdering );
}

#endif // DlgRadioButton_included
