#include "widget/DlgUser.h"

#include "prop/UserPropDialog.h"

#define Inherited DlgWidget

int DlgUser::itsNextWidgetNum = 1;

DlgUser::DlgUser
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_User )
{
    itsWidget = new Label( parent, 	
			   CreateName( "User", name, itsNextWidgetNum ) );
    itsWidget->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
    itsWidget->setAlignment( AlignCenter );

    itsWidget->setMinimumSize( 10, 10 );
}

DlgUser::~DlgUser()
{
    // itsWidget destroyed when its parent is destroyed
}

int DlgUser::DoPropertyDialog( QWidget *parent, char *name )
{
    UserPropDialog dlg( this, parent, name );
    int ret = dlg.exec();

    // Repaint is neccesary because theDialog may have changed this...
    itsWidget->repaint();

    return ret;
}



void DlgUser::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nUser {";
  
    stream << "\n\t\tUserClassHeader {" << itsUserClassHeader << "}";
    stream << "\n\t\tUserClassName {" << itsUserClassName << "}";

    //DlgUser::SaveQt( stream, (const QLabel *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgUser::SaveQt
(
    QTextStream & ,//stream,
    const QLabel* //widget
)
{
}

bool DlgUser::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( key == "UserClassHeader" )
  {
      itsUserClassHeader = value;
  } 
  else if( key == "UserClassName" )
  {
      itsUserClassName = value;
      itsWidget->setText( value );
  }
  else
  {
      // At last DlgWidget catch the rest
      retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgUser::RestoreQt
(
    const QString& ,//key,
    const QString& ,//value,
    QLabel* //widget
)
{
    // Key unknown
    return FALSE;
}  


void DlgUser::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgWidget::GenSrc( dlgWidget, stream, varName, zOrdering );
}


QString DlgUser::GetHeaderFilename() const
{
    return "\"" + itsUserClassHeader + "\"";
}







