#include "widget/GroupBox.h"

#define Inherited QGroupBox

GroupBox::GroupBox
(
    QWidget*		widget,
    const char*		name
)
    :
    Inherited( widget, name )
{
}


void GroupBox::mousePressEvent
(
    QMouseEvent*	event
)
{
    emit MousePress( this, event );	
    //Inherited::mousePressEvent( event );
    
}


void GroupBox::mouseMoveEvent
(
    QMouseEvent*	event
)
{
    emit MouseMove( this, event );
    //Inherited::mouseMoveEvent( event );
    
}


void GroupBox::mouseReleaseEvent
(
    QMouseEvent*	 //event
)
{
    emit MouseRelease();
    //Inherited::mouseReleaseEvent( event );
    
}


void GroupBox::paintEvent
(
    QPaintEvent*	event
)
{
    Inherited::paintEvent( event );
    
    emit Paint( this );
}


void GroupBox::resizeEvent
(
    QResizeEvent*	event
)
{
    Inherited::resizeEvent( event );
    
    emit Resize( this );
}




