#ifndef RadioButton_included
#define RadioButton_included

#include <qradiobt.h>
#include <qdict.h>
#include <qstring.h>

class RadioButton : public QRadioButton
{
    Q_OBJECT
    
public:
    
    RadioButton
    (
	QWidget*	widget,
	const char*	name
    );


signals:

    void MousePress
    (
	QWidget*	widget,
	QMouseEvent*	event
    );

    void MouseMove
    (
	QWidget*	widget,
	QMouseEvent*	event
    );
    
    void MouseRelease();
    
    void Paint
    (
	QWidget*	widget
    );
    
    void Resize
    (
	QWidget*	widget
    );
    
    
protected: // methods

    void mousePressEvent
    ( 
	QMouseEvent*	event 
    );

    void mouseMoveEvent
    (
	QMouseEvent*	event
    );

    void mouseReleaseEvent
    (
	QMouseEvent*	//event
    );
        
    void paintEvent
    (
	QPaintEvent*	event
    );

    void resizeEvent
    (
	QResizeEvent*	//event
    );
};


#endif // RadioButton_included
