#include "widget/ScrollBar.h"

#define Inherited QScrollBar

ScrollBar::ScrollBar
(
    QWidget*		widget,
    const char*		name
)
    :
    Inherited( QScrollBar::Horizontal, widget, name )
{
}


void ScrollBar::mousePressEvent
(
    QMouseEvent*	event
)
{
    emit MousePress( this, event );	
    //Inherited::mousePressEvent( event );
    
}


void ScrollBar::mouseMoveEvent
(
    QMouseEvent*	event
)
{
    emit MouseMove( this, event );
    //Inherited::mouseMoveEvent( event );
    
}


void ScrollBar::mouseReleaseEvent
(
    QMouseEvent*	 //event
)
{
    emit MouseRelease();
    //Inherited::mouseReleaseEvent( event );
    
}


void ScrollBar::paintEvent
(
    QPaintEvent*	event
)
{
    Inherited::paintEvent( event );
    
    emit Paint( this );
}


void ScrollBar::resizeEvent
(
    QResizeEvent*	event
)
{
    Inherited::resizeEvent( event );
    
    emit Resize( this );
}




