#ifndef SignalConnection_included
#define SignalConnection_included

#include <qstring.h>

class SignalConnection
{
public:
    enum Scope
    {
	// no private since slots are declared in the dialog's base class,
	// and a private slot would not be visible by the dialog class
	Protected,
	Public
    };

    SignalConnection();

    SignalConnection( Scope		scope,
		      const QString&	signal,
		      const QString&	slot,
		      const QString&	args );

    QString ToString( void ) const;
    // convert the connection to a string to be placed in a list box for
    // display

    void FromString( const QString& from );
    // convert from the string to a SignalConnection

    SignalConnection::Scope GetScope( void ) const;
    void SetScope( SignalConnection::Scope scope );
    
    // get the signal string with arguments
    const QString GetSignal( void ) const;
    // set both the signal and arguments from the string
    void SetSignal( const QString& sig );

    const QString& GetSignalName( void ) const;
    void SetSignalName( const QString& sig );
    
    // get the slot string with arguments
    const QString GetSlot( void ) const;

    const QString& GetSlotName( void ) const;
    void SetSlotName( const QString& slot );
    

private:
    
    Scope 	itsScope;

    QString	itsSignal;
    QString	itsSlot;
    QString	itsArgs;
};


inline SignalConnection::Scope SignalConnection::GetScope( void ) const
{
    return itsScope;
}


inline void SignalConnection::SetScope( SignalConnection::Scope scope )
{
    itsScope = scope;
}


inline const QString& SignalConnection::GetSignalName( void ) const
{
    return itsSignal;
}


inline void SignalConnection::SetSignalName( const QString& sig )
{
    itsSignal = sig;
}


inline const QString& SignalConnection::GetSlotName( void ) const
{
    return itsSlot;
}


inline void SignalConnection::SetSlotName( const QString& slot )
{
    itsSlot = slot;
}




#endif // SignalConnection_included
