/*
 * Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

#ifdef __GNUG__
#pragma interface
#endif

/*
 * Button - clickable Action
 */

#ifndef ivlook_button_h
#define ivlook_button_h

#include <InterViews/input.h>
#include <InterViews/observe.h>

#include <InterViews/_enter.h>

class Action;
class TelltaleState;

class Button : public ActiveHandler, public Observer {
public:
    Button(Glyph*, Style*, TelltaleState*, Action*);
    virtual ~Button();

    virtual void state(TelltaleState*);
    virtual TelltaleState* state() const;

    virtual void action(Action*);
    virtual Action* action() const;

    virtual void enter();
    virtual void leave();
    virtual void press(const Event&);
    virtual void release(const Event&);

    virtual void update(Observable*);
private:
    TelltaleState* state_;
    Action* action_;
};

#include <InterViews/_leave.h>

#endif
