/*
 * k4engine.c, the konnekt4 game engine
 *
 * Copyright (C) 2000 Baris Mestanogullari <mest0002@tc.umn.edu> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>

#define LEVEL 3

unsigned board[42];

unsigned char moves(unsigned char movelist[7]) {
  unsigned char x,y,n=0;
  for(x=35; x<42; x++)
    for(y=x; y<42; y-=7)
      if (board[y]==0) {
	movelist[n++] = y;
	break;
      }
  return n;
}

char evaluate() {
  unsigned char a;
  char b;

  for(a=38; a<39; a--) {
    b=board[a];
    if(a<21) {
      if(b!=0 && b==board[a+7] && b==board[a+14] && b==board[a+21]) return b;
      if(a<18) {
	if(board[a+3]!=0 && board[a+3]==board[a+9] && board[a+3]==board[a+15] && board[a+3]==board[a+21])
	  return board[a+3];
	if(b!=0 && b==board[a+8] && b==board[a+16] && b==board[a+24])
	  return b;
      }
    }
    if(b!=0 && b==board[a+1] && b==board[a+2] && b==board[a+3])
      return b;
    if(a%7==0) {
      if(--a<21 && board[a]!=0 && board[a]==board[a+7] && board[a]==board[a+14] && board[a]==board[a+21]) return board[a];
      if(--a<21 && board[a]!=0 && board[a]==board[a+7] && board[a]==board[a+14] && board[a]==board[a+21]) return board[a];
      if(--a<21 && board[a]!=0 && board[a]==board[a+7] && board[a]==board[a+14] && board[a]==board[a+21]) return board[a];
    }
  }
  return 0;
}

char minimax(unsigned char dcutoff, char player) {
  char b,mvalue=evaluate();
  unsigned char a, nmoves, movelist[7];

  if(dcutoff>0 && mvalue!=1 && mvalue!=-1 && (nmoves=moves(movelist)) > 0) {
    mvalue=-2*player;
    for(a=0; a<nmoves; a++) {
      board[movelist[a]]=player;
      b=minimax(dcutoff-1,-1*player);
      board[movelist[a]]=0;
      if(b==player)
	return b;
      if((player==1 && b>mvalue) || (player==-1 && b<mvalue))
	mvalue=b;
    }
  }
  return mvalue;
}

int main(int argc, char **argv) {
  char turn,b,mvalue;
  unsigned char movelist[7],bestmove=0,nmoves,a;

  if(argc!=87) {
    printf("Type 'konnekt4' to run konnekt4\n");
    exit(-1);
  }

  for(a=3; a<86; a+=2)
    board[atoi(argv[a])]=atoi(argv[a+1]);

  nmoves=moves(movelist);
  mvalue=-2*(turn=atoi(argv[2]));

  for(a=0; a<nmoves; a++) {
    board[movelist[a]]=turn;
    b=minimax(atoi(argv[1])+LEVEL,-1*turn);
    board[movelist[a]]=0;

    if(b==turn) {
      bestmove=movelist[a];
      break;
    }
    if((turn==1 && b>mvalue) || (turn==-1 && b<mvalue)) {
      bestmove=movelist[a];
      mvalue=b;
    } else if(b==mvalue && abs(3-movelist[a]%7) < abs(3-bestmove%7))
      bestmove=movelist[a];
  }
  
  printf("%d", bestmove);
  return(0);
}
