/*
   CrillionEdit : A level editor for xcrillion levels
   Copyright(C) 1999 by Mike Krueger (mkrueger@inf.fu-berlin.de) 

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

import java.awt. *;
import java.awt.event. *;
import java.awt.image. *;
import java.beans. *;
import java.util. *;
import java.io. *;
import java.applet. *;
import java.net. *;

public class CrillionEdit extends Frame implements ActionListener
{
  MenuBar menubar;
  Menu File, Options, Help;
  MenuItem new_file, open_file, save_file_as, save_file, exit_program;
  MenuItem options, tile_selector;
  MenuItem about;
  int level[][];
  int time;
  int ballx, bally, ballc, balld;
  String fname, directory;
  Image tiles[];
  Image ball[];
  Image background;
  int curtile;
  BufferedImage bimg;
  Graphics2D big;
  static String title_string = "Crillion leveled 1.0 coded 1999 by Mike Krueger";

  class About extends Dialog implements ActionListener
  {
    boolean confirm = false;
    About (Frame window, String text)
    {
      super (window, true);
      enableEvents (AWTEvent.WINDOW_EVENT_MASK);

      add ("Center", new Label (text));
      Panel button = new Panel ();
      Button ok = new Button ("OK");
        ok.addActionListener (this);
        ok.setActionCommand ("ok");
        button.add (ok);
        add ("South", button);
        pack ();
    }
    public void actionPerformed (ActionEvent e)
    {
      String s = e.getActionCommand ();
      if (s.equals ("ok"))
	  confirm = true;
      else
	  confirm = false;
        setVisible (false);
    }
    public void processEvent (AWTEvent e)
    {
      if (e.getID () == Event.WINDOW_DESTROY)
	dispose ();
      else
	super.processEvent (e);
    }
    public boolean conf ()
    {
      return confirm;
    }
  }
  class OptionSelect extends Frame implements ActionListener
  {
    Button ok, cancel;
    TextField time_field;
    Choice color, direction;
    Label l1, l2, l3;
    class WindowListener extends WindowAdapter
    {
      public void windowClosing (WindowEvent event)
      {
	dispose ();
      }
    }
    public void actionPerformed (ActionEvent e)
    {
      String s = e.getActionCommand ();
      String a;
      if (s.equals ("cancel"))
	{
	  dispose ();
	}
      if (s.equals ("ok"))
	{
	  if (color.getSelectedItem ().equals ("red"))
	    ballc = 0;
	  if (color.getSelectedItem ().equals ("green"))
	    ballc = 1;
	  if (color.getSelectedItem ().equals ("blue"))
	    ballc = 2;
	  if (color.getSelectedItem ().equals ("yellow"))
	    ballc = 3;
	  if (color.getSelectedItem ().equals ("purple"))
	    ballc = 4;
	  if (direction.getSelectedItem ().equals ("up"))
	    balld = 0;
	  else
	    balld = 1;
	  a = time_field.getText ();
	  time = Integer.parseInt (a);
	  dispose ();
	}
    }
    OptionSelect ()
    {
      super ("options");
      setSize (400, 120);
      addWindowListener (new WindowListener ());
      setLayout (new FlowLayout (FlowLayout.LEFT, 2, 3));
      l1 = new Label ("Time limit in sec.");
      l2 = new Label ("Ball color & start direction");
      time_field = new TextField ("", 80);
      color = new Choice ();
      color.add ("red");
      color.add ("green");
      color.add ("blue");
      color.add ("yellow");
      color.add ("purple");
      direction = new Choice ();
      direction.add ("up");
      direction.add ("down");
      ok = new Button ("OK");
      ok.addActionListener (this);
      ok.setActionCommand ("ok");
      cancel = new Button ("CANCEL");
      cancel.addActionListener (this);
      cancel.setActionCommand ("cancel");
      time_field.setText ("" + time);
      color.select (ballc);
      direction.select (balld);
      add (l1);
      add (time_field);
      add (l2);
      add (color);
      add (direction);
      add (ok);
      add (cancel);

      setResizable (false);
      show ();
    }
  }

  class TileSelect extends Frame implements ActionListener
  {
    BufferedImage bimg;
    Graphics2D big;

    class WindowListener extends WindowAdapter
    {
      public void windowClosing (WindowEvent event)
      {
	dispose ();
      }
    }
    class Mouse extends MouseAdapter
    {
      int gettile (int x, int y)
      {
	if (y == 0 && x < 15)
	  return x;
	if (y == 1 && x < 5)
	  return 20 + x;
	else if (y == 1 && x < 10)
	  return 30 + x - 5;
	if (y == 2 && x < 5)
	  return 40 + x;
	else if (y == 2 && x < 10)
	  return 50 + x - 5;
	if (y == 3 && x < 5)
	  return 60 + x;
	else if (y == 3 && x < 10)
	  return 25 + x - 5;
	if (y == 4 && x < 6)
	  return 70 + x;
	return curtile;
      }
      public void mousePressed (MouseEvent e)
      {
	int x = e.getX (), y = e.getY ();
	  curtile = gettile ((x - 2) / 34, ((y - 28) / 50));
	  repaint ();
      }
    }
    public TileSelect ()
    {
      super ("Select a Tile");
      curtile = 0;
      setSize (514, 290);
      addWindowListener (new WindowListener ());
      addMouseListener (new Mouse ());
      setResizable (false);
      show ();
      bimg = (BufferedImage) createImage (514, 290);
      big = bimg.createGraphics ();
    }
    public void update (Graphics g)
    {
      paint (g);
    }
    public void showtile (Graphics g, int tile, int x, int y)
    {
      if (curtile == tile)
	{
	  g.setColor (Color.white);
	  g.fillRect (x - 2,
		      y - 2,
		      36,
		      52);
	}
      g.drawImage (tiles[tile], x, y, this);
    }
    public void paint (Graphics g)
    {
      int a, b;

        big.setColor (Color.black);
        big.fillRect (0,
		      0,
		      getSize ().width,
		      getSize ().height);

      for (int x = 0; x < 15; x++)	/* Background & Walls */
	  showtile (big, x, 2 + 34 * x, 28);

      for (int x = 0; x < 5; x++)	/* Spiders */
	  showtile (big, 20 + x, 2 + 34 * x, 28 + 50);
      for (int x = 0; x < 5; x++)	/* Skorpions */
	  showtile (big, 30 + x, 2 + 34 * (x + 5), 28 + 50);

      for (int x = 0; x < 5; x++)	/* Crucifix */
	  showtile (big, 40 + x, 2 + 34 * x, 28 + 100);
      for (int x = 0; x < 5; x++)	/* Eggs */
	  showtile (big, 50 + x, 2 + 34 * (x + 5), 28 + 100);

      for (int x = 0; x < 5; x++)	/* Sandstone */
	  showtile (big, 60 + x, 2 + 34 * x, 28 + 150);
      for (int x = 0; x < 5; x++)	/* Smoke  */
	  showtile (big, 25 + x, 2 + 34 * (x + 5), 28 + 150);

      for (int x = 0; x < 6; x++)	/* Skulls */
	  showtile (big, 70 + x, 2 + 34 * x, 28 + 200);
        g.drawImage (bimg, 0, 0, this);
    }
    public void actionPerformed (ActionEvent e)
    {
      String s = e.getActionCommand ();
      String file_name;
    }
  }
  public void update (Graphics g)
  {
    paint (g);
  }
  public void paint (Graphics g)
  {
    int x, y;
      big.drawImage (background, 1, 24, this);
    for (y = 0; y < 15; y++)
      for (x = 0; x < 32; x++)
	if (level[y][x] > 0)
	    big.drawImage (tiles[level[y][x]], x * 32, 48 + y * 48, this);
      big.drawImage (ball[ballc], ballx, bally, this);
      g.drawImage (bimg, 0, 0, this);
  }
  public CrillionEdit ()
  {
    super (title_string);
    setSize (806, 630);
    addWindowListener (new WindowListener ());
    level = new int[15][32];
      File = new Menu ("File");
      new_file = new Item ("New", "new", this);
      open_file = new Item ("Open", "open", this);
      save_file = new Item ("Save", "save", this);
      save_file_as = new Item ("Save as ...", "save_as", this);
      exit_program = new Item ("Exit", "exit", this);
      addMouseListener (new Mouse ());
      File.add (new_file);
      File.add (open_file);
      File.add (save_file);
      File.add (save_file_as);
      File.add (exit_program);
      Options = new Menu ("Options");
      options = new Item ("Options", "options", this);
      tile_selector = new Item ("Tile selector", "tselect", this);
      Options.add (options);
      Options.add (tile_selector);

      Help = new Menu ("Help");
      about = new Item ("About", "about", this);
      Help.add (about);

      tiles = new Image[255];
      ball = new Image[5];
      ball[0] = Toolkit.getDefaultToolkit ().getImage ("tiles/ball1.gif");
      ball[1] = Toolkit.getDefaultToolkit ().getImage ("tiles/ball2.gif");
      ball[2] = Toolkit.getDefaultToolkit ().getImage ("tiles/ball3.gif");
      ball[3] = Toolkit.getDefaultToolkit ().getImage ("tiles/ball4.gif");
      ball[4] = Toolkit.getDefaultToolkit ().getImage ("tiles/ball5.gif");

      background = Toolkit.getDefaultToolkit ().getImage ("tiles/background.gif");
      tiles[0] = Toolkit.getDefaultToolkit ().getImage ("tiles/black.gif");
      tiles[1] = Toolkit.getDefaultToolkit ().getImage ("tiles/wall1.gif");
      tiles[2] = Toolkit.getDefaultToolkit ().getImage ("tiles/wall2.gif");
      tiles[3] = Toolkit.getDefaultToolkit ().getImage ("tiles/wall3.gif");
      tiles[4] = Toolkit.getDefaultToolkit ().getImage ("tiles/wall4.gif");
      tiles[5] = Toolkit.getDefaultToolkit ().getImage ("tiles/wall5.gif");
      tiles[6] = Toolkit.getDefaultToolkit ().getImage ("tiles/wall6.gif");
      tiles[7] = Toolkit.getDefaultToolkit ().getImage ("tiles/wall7.gif");
      tiles[8] = Toolkit.getDefaultToolkit ().getImage ("tiles/wall8.gif");
      tiles[9] = Toolkit.getDefaultToolkit ().getImage ("tiles/wall9.gif");
      tiles[10] = Toolkit.getDefaultToolkit ().getImage ("tiles/wall10.gif");
      tiles[11] = Toolkit.getDefaultToolkit ().getImage ("tiles/wall11.gif");
      tiles[12] = Toolkit.getDefaultToolkit ().getImage ("tiles/wall12.gif");
      tiles[13] = Toolkit.getDefaultToolkit ().getImage ("tiles/wall13.gif");
      tiles[14] = Toolkit.getDefaultToolkit ().getImage ("tiles/wall14.gif");

      tiles[20] = Toolkit.getDefaultToolkit ().getImage ("tiles/spider1.gif");
      tiles[21] = Toolkit.getDefaultToolkit ().getImage ("tiles/spider2.gif");
      tiles[22] = Toolkit.getDefaultToolkit ().getImage ("tiles/spider3.gif");
      tiles[23] = Toolkit.getDefaultToolkit ().getImage ("tiles/spider4.gif");
      tiles[24] = Toolkit.getDefaultToolkit ().getImage ("tiles/spider5.gif");

      tiles[30] = Toolkit.getDefaultToolkit ().getImage ("tiles/skorpion1.gif");
      tiles[31] = Toolkit.getDefaultToolkit ().getImage ("tiles/skorpion2.gif");
      tiles[32] = Toolkit.getDefaultToolkit ().getImage ("tiles/skorpion3.gif");
      tiles[33] = Toolkit.getDefaultToolkit ().getImage ("tiles/skorpion4.gif");
      tiles[34] = Toolkit.getDefaultToolkit ().getImage ("tiles/skorpion5.gif");

      tiles[40] = Toolkit.getDefaultToolkit ().getImage ("tiles/crucifix1.gif");
      tiles[41] = Toolkit.getDefaultToolkit ().getImage ("tiles/crucifix2.gif");
      tiles[42] = Toolkit.getDefaultToolkit ().getImage ("tiles/crucifix3.gif");
      tiles[43] = Toolkit.getDefaultToolkit ().getImage ("tiles/crucifix4.gif");
      tiles[44] = Toolkit.getDefaultToolkit ().getImage ("tiles/crucifix5.gif");

      tiles[50] = Toolkit.getDefaultToolkit ().getImage ("tiles/egg1.gif");
      tiles[51] = Toolkit.getDefaultToolkit ().getImage ("tiles/egg2.gif");
      tiles[52] = Toolkit.getDefaultToolkit ().getImage ("tiles/egg3.gif");
      tiles[53] = Toolkit.getDefaultToolkit ().getImage ("tiles/egg4.gif");
      tiles[54] = Toolkit.getDefaultToolkit ().getImage ("tiles/egg5.gif");

      tiles[60] = Toolkit.getDefaultToolkit ().getImage ("tiles/sandstone1.gif");
      tiles[61] = Toolkit.getDefaultToolkit ().getImage ("tiles/sandstone2.gif");
      tiles[62] = Toolkit.getDefaultToolkit ().getImage ("tiles/sandstone3.gif");
      tiles[63] = Toolkit.getDefaultToolkit ().getImage ("tiles/sandstone4.gif");
      tiles[64] = Toolkit.getDefaultToolkit ().getImage ("tiles/sandstone5.gif");

      tiles[25] = Toolkit.getDefaultToolkit ().getImage ("tiles/smoke1.gif");
      tiles[26] = Toolkit.getDefaultToolkit ().getImage ("tiles/smoke2.gif");
      tiles[27] = Toolkit.getDefaultToolkit ().getImage ("tiles/smoke3.gif");
      tiles[28] = Toolkit.getDefaultToolkit ().getImage ("tiles/smoke4.gif");
      tiles[29] = Toolkit.getDefaultToolkit ().getImage ("tiles/smoke5.gif");

      tiles[70] = Toolkit.getDefaultToolkit ().getImage ("tiles/skull1.gif");
      tiles[71] = Toolkit.getDefaultToolkit ().getImage ("tiles/skull2.gif");
      tiles[72] = Toolkit.getDefaultToolkit ().getImage ("tiles/skull3.gif");
      tiles[73] = Toolkit.getDefaultToolkit ().getImage ("tiles/skull4.gif");
      tiles[74] = Toolkit.getDefaultToolkit ().getImage ("tiles/skull5.gif");
      tiles[75] = Toolkit.getDefaultToolkit ().getImage ("tiles/skull.gif");

      setResizable (false);
      menubar = new MenuBar ();
      menubar.add (File);
      menubar.add (Options);
      menubar.add (Help);
      setMenuBar (menubar);
      show ();
      bimg = (BufferedImage) createImage (800, 648);
      big = bimg.createGraphics ();
      repaint ();
  }
  void load_level (String file_name)
  {
    int length = 0;
    int x, y, z;
      try
    {
      InputStream in = new FileInputStream (file_name);
        y = (int) in.read () + in.read () * 256;
        x = (int) in.read () + in.read () * 256;
      if (x != 0xFFEE || y != 0xFFEE)
	{
	  About about = new About (this, "not a vaild level file");
	    about.show ();
	  if (about.conf ())
	      about.dispose ();
	    return;
	}
      setTitle (title_string + " (" + fname + ")");
      x = in.read ();
      for (y = 0; y < 15; y++)
	for (x = 0; x < 32; x++)
	  {
	    level[y][x] = in.read ();
	    z = in.read ();
	    z = in.read ();
	    z = in.read ();
	  }
      x = in.read ();
      y = in.read ();
      time = x * 60 + y;
      x = in.read ();
      ballx = (int) in.read () + in.read () * 256;
      bally = (int) in.read () + in.read () * 256;
      ballc = in.read ();
      balld = in.read ();
      if (in != null)
	in.close ();
    }
    catch (IOException ioError)
    {
    }
    bally += 48;
    repaint ();
  }

  void save_level (String file_name)
  {
    int length = 0;
    int x, y, z;
      bally -= 48;
      try
    {
      OutputStream out = new FileOutputStream (file_name);
        out.write (0xEE);	/* sign */
        out.write (0xFF);
        out.write (0xEE);
        out.write (0xFF);
        out.write (0x01);	/* Version Number */

      for (y = 0; y < 15; y++)
	for (x = 0; x < 32; x++)
	  {
	    out.write (level[y][x]);
	    out.write (0x00);
	    out.write (0x00);
	    out.write (0x00);
	  }
      out.write (time / 60);
      out.write (time % 60);
      out.write (0x00);		/* TileSet */
      out.write (ballx % 256);
      out.write (ballx / 256);
      out.write (bally % 256);
      out.write (bally / 256);
      out.write (ballc);
      out.write (balld);
      if (out != null)
	out.close ();
    }
    catch (IOException ioError)
    {
    }
    bally += 48;
  }

  public void actionPerformed (ActionEvent e)
  {
    String s = e.getActionCommand ();
    String file_name;
    int x, y;

    if (s.equals ("about"))
      {
	About about = new About (this, title_string);
	  about.show ();
	if (about.conf ())
	    about.dispose ();
      }
    if (s.equals ("exit"))
        System.exit (0);

    if (s.equals ("open"))
      {
	FileDialog openfile = new FileDialog (this, "Load level", FileDialog.LOAD);
	openfile.setFile ("*.dat");
	openfile.setDirectory (directory);
	openfile.show ();
	file_name = openfile.getFile ();
	if (file_name != null)
	  {
	    directory = openfile.getDirectory ();
	    fname = file_name;
	    load_level (directory + file_name);
	  }
      }
    if (s.equals ("save"))
      {
	if (fname != null)
	  {
	    save_level (directory + fname);
	    About about = new About (this, "File saved");
	    about.show ();
	    if (about.conf ())
	      about.dispose ();
	  }
	else
	  s = "save_as";
      }
    if (s.equals ("save_as"))
      {
	FileDialog openfile = new FileDialog (this, "Save level", FileDialog.SAVE);
	openfile.setFile (fname);
	openfile.setDirectory (directory);
	openfile.show ();
	file_name = openfile.getFile ();
	if (file_name != null)
	  {
	    setTitle (title_string + " (" + file_name + ")");
	    fname = file_name;
	    directory = openfile.getDirectory ();
	    save_level (directory + fname);
	    About about = new About (this, "File saved");
	    about.show ();
	    if (about.conf ())
	      about.dispose ();
	  }
      }
    if (s.equals ("new"))
      {
	setTitle (title_string);
	fname = null;

	for (y = 0; y < 12; y++)
	  for (x = 0; x < 25; x++)
	    if (x == 0 || x == 24 || y == 0 || y == 11)
	      level[y][x] = 1;
	    else
	      level[y][x] = 0;
	time = 300;
	ballx = 400;
	bally = 300;
	ballc = 0;
	balld = 0;
	repaint ();
      }
    if (s.equals ("options"))
      new OptionSelect ();
    if (s.equals ("tselect"))
      new TileSelect ();

  }

  public static void main (String argv[])
  {
    new CrillionEdit ();
  }
  class WindowListener extends WindowAdapter
  {
    public void windowClosing (WindowEvent event)
    {
      System.exit (0);
    }
  }
  class Mouse extends MouseAdapter
  {
    public void mousePressed (MouseEvent e)
    {
      int x = e.getX (), y = e.getY ();
      int m = e.getModifiers ();
      if ((m & MouseEvent.BUTTON1_MASK) != 0)
	  level[(y - 48) / 48][x / 32] = curtile;
      if ((m & MouseEvent.BUTTON2_MASK) != 0)
	  level[(y - 48) / 48][x / 32] = 0;
      if ((m & MouseEvent.BUTTON3_MASK) != 0)
	{
	  ballx = x;
	  bally = y;
	}
      repaint ();
    }
  }
  class Item extends MenuItem
  {
    public Item (String label, String command, ActionListener eventHandler)
    {
      super (label);
      setActionCommand (command);
      addActionListener (eventHandler);
    }
    public Item (String label, String command, ActionListener eventHandler, int key)
    {
      super (label, new MenuShortcut (key));
      setActionCommand (command);
      addActionListener (eventHandler);
    }
  }
}
