/*
    TTFLIB:  A companion library to SDL for working with TrueType (tm) fonts
    Copyright (C) 1997  Sam Lantinga

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com
*/

/* This library is a wrapper around the excellent FreeType 1.0 library,
   available at:
	http://www.physiol.med.tu-muenchen.de/~robert/freetype.html
*/

#include <string.h>
#include "SDL.h"
#include "freetype.h"

typedef struct {
	TT_Face face;
	TT_Instance inst;
	TT_Glyph glyph;
	TT_CharMap map;
	TT_Raster_Map scratch;
} TTF_Font;

/* Initialize the TTF engine - returns 0 if successful, -1 on error */
extern int TTF_Init(void);

/* Open a font file and create a font of the specified point size */
extern TTF_Font *TTF_OpenFont(char *file, int ptsize);

/* Get the general height of a glyph in the specified font */
extern int TTF_FontHeight(TTF_Font *font);

/* Create an 8-bit palettized surface and render the given text at high
   quality with the given font and colors.  The 0 pixel is background,
   while other pixels have varying degrees of the foreground color.
   This function returns the new surface, or NULL if there was an error.
*/
SDL_Surface *TTF_RenderText(TTF_Font *font,
				char *text, SDL_Color fg, SDL_Color bg);

/* Close an opened font file */
extern void TTF_CloseFont(TTF_Font *font);

/* De-initialize the TTF engine */
extern void TTF_Quit(void);

