/*
   This file is part of xcrillion
   available at: http://www.fu-berlin.de/~mkrueger/xcrillion
   and placed under the same license as xcrillion.
 */
#include"action.h"

Actionstruct action[100];
int num_action = 0;


int add_action(int type, int a, int b, int c, int d)
{
    if (num_action > 99)
	return 0;
    memset(&action[num_action], 0, sizeof(action[num_action]));
    action[num_action].type = type;
    action[num_action].p1 = a;
    action[num_action].p2 = b;
    action[num_action].p3 = c;
    action[num_action].p4 = d;
    num_action++;
    return 1;
}


void kill_action(int x)
{
    if (x < num_action) {
	memcpy(&action[x], &action[x + 1], (num_action - x) * sizeof(Actionstruct));
	num_action--;
    }
}

void remove_all_actions()
{
    num_action = 0;
}

void do_action(Levelstruct * level, SDL_Surface * screen, TileSetstruct * tileset)
{
    SDL_Surface *image;
    int x, x1, x2, y1, y2;
    int a, b;
    SDL_Rect dest;

    for (x = 0; x < num_action; x++) {
	switch (action[x].type) {
	case DO_REMOVE:
	    x1 = action[x].p1;
	    y1 = action[x].p2;
	    a = action[x].p3;

	    dest.x = x1 * TILE_WIDTH;
	    dest.y = 24 + y1 * TILE_HEIGHT;
	    dest.w = tileset->tile[a]->w;
	    dest.h = tileset->tile[a]->h;

	    SDL_BlitSurface(tileset->background, &dest, screen, &dest);

	    image = SDL_DisplayFormat(tileset->tile[a]);
	    SDL_SetAlpha(image, SDL_SRCALPHA, action[x].status * 15);
	    SDL_BlitSurface(image, NULL, screen, &dest);
	    SDL_FreeSurface(image);

	    SDL_UpdateRects(screen, 1, &dest);
	    if (action[x].status++ >= 17)
		kill_action(x);

	    break;

	case DO_MORPH:
	    x1 = action[x].p1;
	    y1 = action[x].p2;
	    a = action[x].p3;
	    b = action[x].p4;
	    if (action[x].status == 0) {
		level->level[y1][x1].stone_type = b;
	    }
	    dest.x = x1 * TILE_WIDTH;
	    dest.y = 24 + y1 * TILE_HEIGHT;
	    dest.w = tileset->tile[b]->w;
	    dest.h = tileset->tile[b]->h;
	    SDL_BlitSurface(tileset->tile[a], NULL, screen, &dest);

	    image = SDL_DisplayFormat(tileset->tile[b]);
	    SDL_SetAlpha(image, SDL_SRCALPHA, (240 - action[x].status * 20));
	    SDL_BlitSurface(image, NULL, screen, &dest);
	    SDL_FreeSurface(image);

	    SDL_UpdateRects(screen, 1, &dest);
	    if (action[x].status++ > 11)
		kill_action(x);
	    break;

	case DO_KILLSTONE:
	    x1 = action[x].p1;
	    y1 = action[x].p2;
	    if (action[x].status == 0) {
		level->level[y1][x1].stone_type = 0;
		action[x].status++;
		break;
	    }
	    dest.x = x1 * TILE_WIDTH;
	    dest.y = 24 + y1 * TILE_HEIGHT;
	    dest.w = tileset->tile[level->level[y1][x1].stone_type]->w;
	    dest.h = action[x].status;
	    SDL_BlitSurface(tileset->background, &dest, screen, &dest);
	    SDL_UpdateRects(screen, 1, &dest);

	    dest.x = x1 * TILE_WIDTH;
	    dest.y = 24 + y1 * TILE_HEIGHT + (TILE_HEIGHT - action[x].status);
	    dest.w = tileset->tile[level->level[y1][x1].stone_type]->w;
	    dest.h = action[x].status;
	    SDL_BlitSurface(tileset->background, &dest, screen, &dest);

	    SDL_UpdateRects(screen, 1, &dest);
	    if (action[x].status++ > 24)
		kill_action(x);
	    break;

	case DO_MOVE:

	    x1 = action[x].p1;
	    y1 = action[x].p2;
	    x2 = action[x].p3;
	    y2 = action[x].p4;

	    if (action[x].status == 0) {
		action[x].a1 = level->level[y1][x1].stone_type;
		level->level[y2][x2].stone_type = action[x].a1;
		level->level[y1][x1].stone_type = 0;
	    }
	    a = (x2 - x1);
	    b = (y2 - y1);
	    if (a < 0)
		dest.x = x1 * TILE_WIDTH + a * action[x].status - (a * tileset->tile[0]->w);
	    else
		dest.x = x1 * TILE_WIDTH + a * action[x].status - 2 * a;
	    if (b < 0)
		dest.y = 24 + y1 * TILE_HEIGHT + b * action[x].status - (b * tileset->tile[0]->h);
	    else
		dest.y = 24 + y1 * TILE_HEIGHT + b * action[x].status - 2 * b;
	    dest.w = 2 + b * b * TILE_WIDTH;
	    dest.h = 2 + a * a * TILE_HEIGHT;
	    SDL_BlitSurface(tileset->background, &dest, screen, &dest);
	    SDL_UpdateRects(screen, 1, &dest);

	    dest.x = x1 * TILE_WIDTH + a * action[x].status;
	    dest.y = 24 + y1 * TILE_HEIGHT + b * action[x].status;
	    dest.w = tileset->tile[0]->w;
	    dest.h = tileset->tile[0]->h;
	    SDL_BlitSurface(tileset->tile[action[x].a1], NULL, screen, &dest);
	    SDL_UpdateRects(screen, 1, &dest);


	    if ((x1 + action[x].status * a / TILE_WIDTH == x2) &&
		(y1 + action[x].status * b / TILE_HEIGHT == y2))
		kill_action(x);

	    action[x].status++;
	    break;
	}
    }
}
