/*
   This file is part of xcrillion
   available at: http://www.fu-berlin.de/~mkrueger/xcrillion
   and placed under the same license as xcrillion.
 */
#include "level.h"

void init_Ballstruct(Ballstruct *ball)
{
	char filename[80];
	int x;
	ball->speedy = 0;
	ball->speedx = 0;
	ball->back = SDL_LoadBMP(INSTALL_PATH "tiles/ball1.bmp");
	for (x = 1; x <= 5; x++) {
		sprintf(filename, INSTALL_PATH "tiles/ball%d.bmp", x);
		ball->color_img[5] = SDL_LoadBMP(filename);
		SDL_SetColorKey(ball->color_img[5], (SDL_SRCCOLORKEY | SDL_RLEACCEL), *(Uint32 *) ball->color_img[5]->pixels);
		ball->color_img[x - 1] = SDL_DisplayFormat(ball->color_img[5]);
		SDL_FreeSurface(ball->color_img[5]);
	}
	ball->speedy = 2;
	ball->w = ball->color_img[1]->w;
	ball->h = ball->color_img[1]->h;
	ball->painted = 0;
}

int load_level(char *filename, Levelstruct * level)
{
	int x, y;
	FILE *fp;
	fp = fopen(filename, "rb");
	if (fp == NULL)
		return 0;
	fread(&level->Magic_number, 4, 1, fp);
	if (level->Magic_number != 0xFFEEFFEE)
		return 0;
	fread(&level->Version, 1, 1, fp);
	for (y = 0; y < 15; y++)
	for (x = 0; x < 32; x++) {
		fread(&level->level[y][x].stone_type, 1, 1, fp);
		fread(&level->level[y][x].argument1, 1, 1, fp);
		fread(&level->level[y][x].argument2, 1, 1, fp);
		fread(&level->level[y][x].argument3, 1, 1, fp);
	}
	fread(&level->Minutes, 1, 1, fp);
	fread(&level->Seconds, 1, 1, fp);
	fread(&level->Tileset, 1, 1, fp);
	fread(&level->Ball_x, 2, 1, fp);
	fread(&level->Ball_y, 2, 1, fp);
	fread(&level->Ball_Color, 1, 1, fp);
	fread(&level->Ball_Direction, 1, 1, fp);
	fclose(fp);
	return 1;
}

int save_level(char *filename, Levelstruct * level)
{
	int x, y;
	FILE *fp;
	fp = fopen(filename, "wb");
	level->Magic_number = 0xFFEEFFEE;
	level->Version = 1;
	fwrite(&level->Magic_number, 4, 1, fp);
	fwrite(&level->Version, 1, 1, fp);
	for (y = 0; y < 15; y++)
	for (x = 0; x < 32; x++) {
		fwrite(&level->level[y][x].stone_type, 1, 1, fp);
		fwrite(&level->level[y][x].argument1, 1, 1, fp);
		fwrite(&level->level[y][x].argument2, 1, 1, fp);
		fwrite(&level->level[y][x].argument3, 1, 1, fp);
	}
	fwrite(&level->Minutes, 1, 1, fp);
	fwrite(&level->Seconds, 1, 1, fp);
	fwrite(&level->Tileset, 1, 1, fp);
	fwrite(&level->Ball_x, 2, 1, fp);
	fwrite(&level->Ball_y, 2, 1, fp);
	fwrite(&level->Ball_Color, 1, 1, fp);
	fwrite(&level->Ball_Direction, 1, 1, fp);
	fclose(fp);
	return 1;
}

int load_tileset(int num, TileSetstruct * tileset)
{
	int x;
	SDL_Surface *temp;
	 
	for (x=0;x<255;x++)
		tileset->tile[x]=NULL;
		
	
	tileset->tile[0] = SDL_LoadBMP(INSTALL_PATH "tiles/black.bmp");

	tileset->tile[1] = SDL_LoadBMP(INSTALL_PATH "tiles/wall1.bmp");
	tileset->tile[2] = SDL_LoadBMP(INSTALL_PATH "tiles/wall2.bmp");
	tileset->tile[3] = SDL_LoadBMP(INSTALL_PATH "tiles/wall3.bmp");
	tileset->tile[4] = SDL_LoadBMP(INSTALL_PATH "tiles/wall4.bmp");
	tileset->tile[5] = SDL_LoadBMP(INSTALL_PATH "tiles/wall5.bmp");
	tileset->tile[6] = SDL_LoadBMP(INSTALL_PATH "tiles/wall6.bmp");
	tileset->tile[7] = SDL_LoadBMP(INSTALL_PATH "tiles/wall7.bmp");
	tileset->tile[8] = SDL_LoadBMP(INSTALL_PATH "tiles/wall8.bmp");
	tileset->tile[9] = SDL_LoadBMP(INSTALL_PATH "tiles/wall9.bmp");
	tileset->tile[10] = SDL_LoadBMP(INSTALL_PATH "tiles/wall10.bmp");
	tileset->tile[11] = SDL_LoadBMP(INSTALL_PATH "tiles/wall11.bmp");
	tileset->tile[12] = SDL_LoadBMP(INSTALL_PATH "tiles/wall12.bmp");
	tileset->tile[13] = SDL_LoadBMP(INSTALL_PATH "tiles/wall13.bmp");
	tileset->tile[14] = SDL_LoadBMP(INSTALL_PATH "tiles/wall14.bmp");

	tileset->tile[20] = SDL_LoadBMP(INSTALL_PATH "tiles/spider1.bmp");
	tileset->tile[21] = SDL_LoadBMP(INSTALL_PATH "tiles/spider2.bmp");
	tileset->tile[22] = SDL_LoadBMP(INSTALL_PATH "tiles/spider3.bmp");
	tileset->tile[23] = SDL_LoadBMP(INSTALL_PATH "tiles/spider4.bmp");
	tileset->tile[24] = SDL_LoadBMP(INSTALL_PATH "tiles/spider5.bmp");

	tileset->tile[30] = SDL_LoadBMP(INSTALL_PATH "tiles/skorpion1.bmp");
	tileset->tile[31] = SDL_LoadBMP(INSTALL_PATH "tiles/skorpion2.bmp");
	tileset->tile[32] = SDL_LoadBMP(INSTALL_PATH "tiles/skorpion3.bmp");
	tileset->tile[33] = SDL_LoadBMP(INSTALL_PATH "tiles/skorpion4.bmp");
	tileset->tile[34] = SDL_LoadBMP(INSTALL_PATH "tiles/skorpion5.bmp");

	tileset->tile[40] = SDL_LoadBMP(INSTALL_PATH "tiles/crucifix1.bmp");
	tileset->tile[41] = SDL_LoadBMP(INSTALL_PATH "tiles/crucifix2.bmp");
	tileset->tile[42] = SDL_LoadBMP(INSTALL_PATH "tiles/crucifix3.bmp");
	tileset->tile[43] = SDL_LoadBMP(INSTALL_PATH "tiles/crucifix4.bmp");
	tileset->tile[44] = SDL_LoadBMP(INSTALL_PATH "tiles/crucifix5.bmp");

	tileset->tile[50] = SDL_LoadBMP(INSTALL_PATH "tiles/egg1.bmp");
	tileset->tile[51] = SDL_LoadBMP(INSTALL_PATH "tiles/egg2.bmp");
	tileset->tile[52] = SDL_LoadBMP(INSTALL_PATH "tiles/egg3.bmp");
	tileset->tile[53] = SDL_LoadBMP(INSTALL_PATH "tiles/egg4.bmp");
	tileset->tile[54] = SDL_LoadBMP(INSTALL_PATH "tiles/egg5.bmp");

	tileset->tile[60] = SDL_LoadBMP(INSTALL_PATH "tiles/sandstone1.bmp");
	tileset->tile[61] = SDL_LoadBMP(INSTALL_PATH "tiles/sandstone2.bmp");
	tileset->tile[62] = SDL_LoadBMP(INSTALL_PATH "tiles/sandstone3.bmp");
	tileset->tile[63] = SDL_LoadBMP(INSTALL_PATH "tiles/sandstone4.bmp");
	tileset->tile[64] = SDL_LoadBMP(INSTALL_PATH "tiles/sandstone5.bmp");

	tileset->tile[70] = SDL_LoadBMP(INSTALL_PATH "tiles/skull1.bmp");
	tileset->tile[71] = SDL_LoadBMP(INSTALL_PATH "tiles/skull2.bmp");
	tileset->tile[72] = SDL_LoadBMP(INSTALL_PATH "tiles/skull3.bmp");
	tileset->tile[73] = SDL_LoadBMP(INSTALL_PATH "tiles/skull4.bmp");
	tileset->tile[74] = SDL_LoadBMP(INSTALL_PATH "tiles/skull5.bmp");

	temp = SDL_LoadBMP(INSTALL_PATH "tiles/smoke1.bmp");
	SDL_SetAlpha(temp, SDL_SRCALPHA, 128);
	tileset->tile[25] = SDL_DisplayFormat(temp);
	temp = SDL_LoadBMP(INSTALL_PATH "tiles/smoke2.bmp");
	SDL_SetAlpha(temp, SDL_SRCALPHA, 128);
	tileset->tile[26] = SDL_DisplayFormat(temp);
	temp = SDL_LoadBMP(INSTALL_PATH "tiles/smoke3.bmp");
	SDL_SetAlpha(temp, SDL_SRCALPHA, 128);
	tileset->tile[27] = SDL_DisplayFormat(temp);
	temp = SDL_LoadBMP(INSTALL_PATH "tiles/smoke4.bmp");
	SDL_SetAlpha(temp, SDL_SRCALPHA, 128);
	tileset->tile[28] = SDL_DisplayFormat(temp);
	temp = SDL_LoadBMP(INSTALL_PATH "tiles/smoke5.bmp");
	SDL_SetAlpha(temp, SDL_SRCALPHA, 128);
	tileset->tile[29] = SDL_DisplayFormat(temp);

	tileset->tile[75] = SDL_LoadBMP(INSTALL_PATH "tiles/skull.bmp");
	tileset->background = SDL_LoadBMP(INSTALL_PATH "tiles/background.bmp");
	return 1;
}

void free_Tileset(TileSetstruct *tileset)
{
	int x;
	for (x=0;x<255;x++) {
		if (tileset->tile[x] != NULL)
			SDL_FreeSurface(tileset->tile[x]);
	}
	SDL_FreeSurface(tileset->background);
}

void free_Ballstruct(Ballstruct *ball)
{
	int x;
	for (x=0;x<5;x++)
		SDL_FreeSurface(ball->color_img[x]);
	SDL_FreeSurface(ball->back);
}
