/*
    This file is part of xcrillion
    available at: http://www.fu-berlin.de/~mkrueger/xcrillion
    and placed under the same license as xcrillion.
*/
#ifndef C_LEVEL
#define C_LEVEL
#include <SDL.h>
#include <stdio.h>

#define  TILE_WIDTH  32
#define  TILE_HEIGHT 48

typedef struct {
   unsigned int  Magic_number;  /*Should be 0xFFEEFFEE */
   unsigned char Version;       /* Current = 0x01 */
   struct {
      unsigned char stone_type;
      unsigned char argument1;
      unsigned char argument2;
      unsigned char argument3;
   } level[15][32];
   unsigned char  Minutes,Seconds;
   unsigned char  Tileset;         /*Currently only 1 :( */
   unsigned short Ball_x;         
   unsigned short Ball_y;
   unsigned char  Ball_Color;
   unsigned char  Ball_Direction;  /*=0 -> Up !=0 -> Down */
} Levelstruct;

typedef struct {
   SDL_Surface *tile[255];
   SDL_Surface *background;
} TileSetstruct;

typedef struct {
  SDL_Surface *back;
  SDL_Surface *color_img[6];
  unsigned int w, h;
  int x,y;
  int color;
  int painted;
  int speedy,speedx;
} Ballstruct;

/* Load Ball pictures & set ball speed, painted = 0*/
extern void init_Ballstruct(Ballstruct *ball);

/* Load Tiles 
 *  Tiles: 0       - Black Square
 *         1..10   - Wall
 *            11   - Color Changer
 *        20..24   - Colored Spiders
 *        30..34   - Colored Scorpions
 *        40..44   - Color Changers
 *        50..54   - Moveable Stones
 *        60..64   - Colored Walls
 *        70..74   - Colored Skulls
 *        75       - Skull
 */
extern int load_tileset(int num,TileSetstruct *tileset);

/*Load a level*/
extern int load_level(char *filename,Levelstruct *level);

/*Save a level*/
extern int save_level(char *filename,Levelstruct *level);

/*Deallocate Memory from Tileset*/
extern void free_Tileset(TileSetstruct *tileset);

/*Deallocate Memory from Ballstruct*/
extern void free_Ballstruct(Ballstruct *ball);

#endif
