
/* This file supports streaming WAV files, without volume adjustment */

#include <stdio.h>

typedef struct {
	FILE *wavefp;
	long  start;
	long  stop;
	SDL_AudioCVT cvt;
} WAVStream;

/* Initialize the WAVStream player, with the given mixer settings
   This function returns 0, or -1 if there was an error.
 */
extern int WAVStream_Init(SDL_AudioSpec *mixer);

/* Unimplemented */
extern void WAVStream_SetVolume(int volume);

/* Load a WAV stream from the given file */
extern WAVStream *WAVStream_LoadSong(const char *file, const char *magic);

/* Start playback of a given WAV stream */
extern void WAVStream_Start(WAVStream *wave);

/* Play some of a stream previously started with WAVStream_Start() */
extern void WAVStream_PlaySome(Uint8 *stream, int len);

/* Stop playback of a stream previously started with WAVStream_Start() */
extern void WAVStream_Stop(void);

/* Close the given WAV stream */
extern void WAVStream_FreeSong(WAVStream *wave);

/* Return non-zero if a stream is currently playing */
extern int WAVStream_Active(void);
