 
#ifndef SKEL_H 
#define SKEL_H 
 
#include <kapp.h> 
#include <ktmainwindow.h> 
#include <kfiledialog.h>
#include <kaccel.h>
#include <kiconloader.h>
/**
  * The implementation and documentation is only an example,you must change
  * it for your own program :)
  */
class Skel : public KTMainWindow { 
  Q_OBJECT 
public: 
  /** construtor */
  Skel(); 
  /** destructor */
  ~Skel();
  /** the init-method call all other initxxx-methods and 
    * initiate some other stuff
    */
  void init();  
  /** setup the menu */
  void initMenu(); 
  /** setup the toolbar */
  void initToolbar();
  /** setup the statusbar */
  void initStatusBar(); 

  protected slots: 
  /** generate a new document */
  void slotFileNew(); 
  /** open a document */
  void slotFileOpen();
  /** save a document */
  void slotFileSave(); 
  /** save a document under a different filename*/
  void slotFileSaveAs();
  /** put the marked text/object into the clipboard and remove it from the document*/
  void slotEditCut(); 
  /** put the marked text/object into the clipboard*/
  void slotEditCopy(); 
  /** paste the clipboard into the document*/
  void slotEditPaste(); 
  /** is called if the toolbar was clicked 
   * @param item the index for the button,which was clicked
   */
  void slotToolbarClicked(int item);
  /** toggle the toolbar*/
  void slotViewTToolbar(); 
  /** toggle the statusbar*/
  void slotViewTStatusbar(); 
 
private: 
  // the mainview
  QWidget* view; 
  enum {TOOLBAR_NEW, TOOLBAR_OPEN,TOOLBAR_SAVE, TOOLBAR_COPY, TOOLBAR_PASTE, 
	TOOLBAR_CUT }; 
  enum {STATUSBAR_TEXT};
}; 
 
#endif 
 
 
 
 
 
 
 
 
