/***************************************************************************
           clogfileview.cpp - the logical file view,draw the contents of 
		           a projectfile into a tree
                             -------------------                                         

    version              :                                   
    begin                : 20 Jul 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include "clogfileview.h"
#include <iostream.h>
#include <kmsgbox.h>

CLogFileView::CLogFileView(QWidget*parent,const char* name) : KTreeList(parent,name){
  icon_loader = KApplication::getKApplication()->getIconLoader();
}

CLogFileView::~CLogFileView(){
}

void CLogFileView::refresh(struct CProjectInfo* prj){ 
  clear();
  if (!prj->valid){
    return; // no correct project
  }
  KPath path;
  QString str;
  QString file;
  QString str_path;
  QString str_sub_path;

  QPixmap doc_pix = icon_loader->loadMiniIcon("mini-edit.xpm");
  QPixmap source_pix = icon_loader->loadMiniIcon("c_src.xpm");

  path.push(&prj->name);  
  insertItem(prj->name,&icon_loader->loadMiniIcon("kwm.xpm"));
  addChildItem("Headers",&icon_loader->loadMiniIcon("folder.xpm"),&path);
  addChildItem("Sources",&icon_loader->loadMiniIcon("folder.xpm"),&path);
  addChildItem("Standard-Files",&icon_loader->loadMiniIcon("folder.xpm"),&path);
  addChildItem("Other",&icon_loader->loadMiniIcon("folder.xpm"),&path);
  
  //  add the Headers
  str_path = "Headers";
  path.push(&str_path);
  if(!prj->header_files.isEmpty()){ // if not empty
    for(file=prj->header_files.first();file != 0;file=prj->header_files.next()){
      addChildItem(file,&source_pix,&path);
    }
  }
  // add the sources
  str_path = "Sources";
  path.pop();
  path.push(&str_path);
  if(!prj->cpp_files.isEmpty()){ // if not empty
    for(file=prj->cpp_files.first();file != 0;file=prj->cpp_files.next()){
      addChildItem(file,&source_pix,&path);
    }
  }
  // the Other files
 
  str_path = "Other";
  path.pop();
  path.push(&str_path);
  if(!prj->other_files.isEmpty()){ // if not empty
    for(file=prj->other_files.first();file != 0;file=prj->other_files.next()){
      addChildItem(file,&doc_pix,&path);
    }
  }
  // add the standard-files
  str_path = "Standard-Files";
  path.pop();
  path.push(&str_path);
  addChildItem("GNU",&icon_loader->loadMiniIcon("emacs.xpm"),&path);
  addChildItem("Linux",&icon_loader->loadMiniIcon("pinguin.xpm"),&path);
  addChildItem("KDE",&icon_loader->loadMiniIcon("mini-k.xpm"),&path);
  
  // the GNU-Part
  str_sub_path = "GNU";
  path.push(&str_sub_path);
  if(!prj->gnu_files.isEmpty()){ // if not empty
    for(file=prj->gnu_files.first();file != 0;file=prj->gnu_files.next()){
      addChildItem(file,&doc_pix,&path);
    }
  }
  // the Linux-Part
  path.pop();
  str_sub_path = "Linux";
  path.push(&str_sub_path);
  if(!prj->linux_files.isEmpty()){ // if not empty
    for(file=prj->linux_files.first();file != 0;file=prj->linux_files.next()){
      addChildItem(file,&doc_pix,&path);
    }
  }
  // the KDE-Part
  path.pop();
  str_sub_path = "KDE";
  path.push(&str_sub_path);
  if(!prj->kde_files.isEmpty()){ // if not empty
    for(file=prj->kde_files.first();file != 0;file=prj->kde_files.next()){
      addChildItem(file,&doc_pix,&path);
    }
  }
  setExpandLevel(2);
}

