/***************************************************************************
                 cprojectinfo.cpp - the projectproperties
                             -------------------                                         

    version              :                                   
    begin                : 28 Jul 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cprojectinfo.h"
#include <iostream.h>

CProjectInfo::CProjectInfo(){
}

CProjectInfo::~CProjectInfo(){
}

void CProjectInfo::readProject(QString file){
  QString in_str;
  QString str;
  // clear the lists
  header_files.clear();
  cpp_files.clear();
  gnu_files.clear();
  linux_files.clear();
  kde_files.clear();
  other_files.clear();
  
  QFile f(file);
  f.open(IO_ReadOnly);
  QTextStream stream(&f);
  QFileInfo fileinfo(file);
  
  if (!(QFile::exists(file))){
    cerr << "could not read the projectfile";
    return;
  }
  prjfile = file;
  dir = fileinfo.dirPath() + "/";
  
  while(!stream.eof()){
    in_str = stream.readLine();
    if (in_str.find("#AUTHOR") != -1){
      author = stream.readLine();
    }
    if (in_str.find("#EMAIL") != -1){
      email = stream.readLine();
    }
    if (in_str.find("#PROJECT_NAME") != -1){
      name = stream.readLine();
    }
    // if (in_str.find("#PROJECT_DIR") != -1){
    //  dir = stream.readLine();
    // }
    if (in_str.find("#PROJECT_SUB_DIR") != -1){
      sub_dir = stream.readLine();
    }
    if (in_str.find("#VERSION") != -1){
      version = stream.readLine();
    }
    if (in_str.find("#SGML_FILE") != -1){
      sgml_file = stream.readLine();
    }
    // and now the files
    if (in_str.find("#BEGIN_HEADERS") != -1){
      in_str = stream.readLine();
      while (in_str.find("#END_HEADERS") == -1){
	header_files.append(in_str);
	in_str =stream.readLine();
      }
    }
    if (in_str.find("#BEGIN_SOURCES") != -1){
      in_str = stream.readLine();
      while (in_str.find("#END_SOURCES") == -1){
	cpp_files.append(in_str);
	in_str =stream.readLine();
      }
    }
    if (in_str.find("#BEGIN_GNU") != -1){
      in_str = stream.readLine();
      while (in_str.find("#END_GNU") == -1){
	gnu_files.append(in_str);
	in_str =stream.readLine();
      }
    }
    if (in_str.find("#BEGIN_LINUX") != -1){
      in_str = stream.readLine();
      while (in_str.find("#END_LINUX") == -1){
	linux_files.append(in_str);
	in_str =stream.readLine();
      }
    }
    if (in_str.find("#BEGIN_KDE") != -1){
      in_str = stream.readLine();
      while (in_str.find("#END_KDE") == -1){
	kde_files.append(in_str);
	in_str =stream.readLine();
      }
    }
    if (in_str.find("#BEGIN_OTHER") != -1){
      in_str = stream.readLine();
      while (in_str.find("#END_OTHER") == -1){
	other_files.append(in_str);
	in_str =stream.readLine();
      }
    }
  }
  f.close();
  writeProject();
}
void CProjectInfo::writeProject(){
  QFile f(prjfile);
  f.open(IO_WriteOnly);
  QTextStream stream(&f);
  QString str;

  stream << "KDevelop Project File Version 0.3 #DO NOT EDIT#\n";
  stream << "\n";
  stream << "#AUTHOR\n";
  stream << author << endl;
  stream << "#EMAIL\n";
  stream << email << endl;
  stream << "#PROJECT_NAME\n";
  stream << name << endl;
  stream << "#PROJECT_DIR\n";
  stream << dir << endl;
  stream << "#PROJECT_SUB_DIR\n";
  stream << sub_dir << endl;
  stream << "#VERSION\n";
  stream << version << endl;
  stream << "#SGML_FILE\n";
  stream << sgml_file << endl;
  stream << endl;

  stream << "#BEGIN_HEADERS\n";
  if(!header_files.isEmpty()){
    for(str=header_files.first();str != 0;str=header_files.next()){
      stream << str << endl;
    }
  }
  stream << "#END_HEADERS\n\n";
  
  stream << "#BEGIN_SOURCES\n";
  if(!cpp_files.isEmpty()){
    for(str=cpp_files.first();str != 0;str=cpp_files.next()){
      stream << str << endl;
    }
  }
  stream << "#END_SOURCES\n\n";

  stream << "#BEGIN_GNU\n";
  if(!gnu_files.isEmpty()){
    for(str=gnu_files.first();str != 0;str=gnu_files.next()){
      stream << str << endl;
    }
  }
  stream << "#END_GNU\n\n";
  
  stream << "#BEGIN_LINUX\n";
  if(!linux_files.isEmpty()){
    for(str=linux_files.first();str != 0;str=linux_files.next()){
      stream << str << endl;
    }
  }
  stream << "#END_LINUX\n\n";
  
  stream << "#BEGIN_KDE\n";
  if(!kde_files.isEmpty()){
    for(str=kde_files.first();str != 0;str=kde_files.next()){
      stream << str << endl;
    }
  }
  stream << "#END_KDE\n\n";

  stream << "#BEGIN_OTHER\n";
   if(!other_files.isEmpty()){
    for(str=other_files.first();str != 0;str=other_files.next()){
      stream << str << endl;
    }
  }
   stream << "#END_OTHER\n\n";
   f.close();
}
