/***************************************************************************
                    cprojectinfo.h - the projectproperties
                             -------------------                                         

    version              :                                   
    begin                : 28 Jul 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#ifndef CPROJECTINFO_H
#define CPROJECTINFO_H

#include <qstring.h>
#include <qstrlist.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qfileinfo.h>

/** this class includes the properties of a project and some methods to read
  * and write the props
  *@author Sandy Meier
  */
class CProjectInfo  {

public: 
  /** construtor */
  CProjectInfo(); 
  /** destructor */
  ~CProjectInfo();
  /** read the projectfile */
  void readProject(QString file); 
  /** write the projectfile to the disk*/
  void writeProject(); 
  /** true if the project was read*/
  bool valid; 
  // read from the projectfile
  /** the projectfile*/
  QString prjfile;
  /** the name of the author*/
  QString author;
  /** the email address*/
  QString email;
  /** the name of the project*/
  QString name;
  /** the toplevel dir of the project*/
  QString dir;
  /** the subdir*/
  QString sub_dir;
  /** the version number*/
  QString version;
  /** the sgml-file for the english manual, 
    * this should be changed in the future
    */
  QString sgml_file;
  /** a list of all cpp-files in the project*/
  QStrList cpp_files;
  /** a list of all header-files in the project*/
  QStrList header_files;
  /** a list of all GNU related file in the project*/
  QStrList gnu_files;
  /** a list of all Linux related file in the project*/
  QStrList linux_files;
  /** a list of all KDE related file in the project*/
  QStrList kde_files;
  /** all other files in the prject*/
  QStrList other_files;
};
#endif
