/***************************************************************************
                    kappwizard.cpp - the kde-application-wizard
                             -------------------                                         

    version              :                                   
    begin                : 9 Sept 1998                                        
    copyright            : (C) 1998 by Stefan Heidrich                         
    email                : sheidric@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "kappwizard.h"

KAppWizard::KAppWizard(QWidget* parent,const char* name) : KWizard(parent,name,true){
  
  init();
  initPages();
  slotDefaultClicked();    
  show();
}

void KAppWizard::init(){
  
  // create the main widget of kAppWizard : a KDE-Wizard
  //  view = new KWizard(this);  

  // set the geometry, the buttons, create the help and the connections for the buttons  
  //setView(view);
  setFixedSize(400,400);
  setCancelButton(i18n("Exit"));
  cancelButton = new QButton();
  cancelButton = getCancelButton();
  QToolTip::add(cancelButton,i18n("exit the KAppWizard"));
  connect(this,SIGNAL(cancelclicked()),SLOT(slotAppEnd()));
  setOkButton(i18n("Create"));
  okButton = new QButton();
  okButton = getOkButton();
  QToolTip::add(okButton,i18n("creating the project"));
  connect(this,SIGNAL(okclicked()),SLOT(slotOkClicked()));
  setDefaultButton();
  defaultButton = new QButton();
  defaultButton = getDefaultButton();
  QToolTip::add(defaultButton,i18n("set all changes back"));
  connect(this,SIGNAL(defaultclicked(int)),SLOT(slotDefaultClicked()));
  setEnableArrowButtons(true);
}

void KAppWizard::initPages(){
  
  // create the first page
  page0 = new KWizardPage;
  widget0 = new QWidget(this);
  page0->w = widget0;
  page0->title = (i18n("KWizard"));
  addPage(page0);
  
  QPixmap iconpm;    
  QPixmap minipm;
  QPixmap pm;
  pm.load(KApplication::kde_datadir() + "/kdevelop/pics/kAppWizard.bmp");
  
  // create a widget and paint a picture on it
  widget1a = new QWidget(widget0);
  widget1a->setGeometry(0,0,400,140);
  widget1a->setBackgroundPixmap(pm);
  // create another widget for a picture
  widget1b = new QWidget(widget0);
  widget1b->setGeometry(230,150,140,140);
  separator0 = new KSeparator (widget0);
  separator0->setGeometry(0,140,400,5);
  // create the RadioButtonGroup with all buttons, bubble-help and connections
  bgroup = new QButtonGroup(i18n("Application"),widget0);
  bgroup->setGeometry(20,170,180,100);
  kna = new QRadioButton (i18n("KDE-Application"),widget0);
  kna->setGeometry(30,190,145,30);
  QToolTip::add(kna,i18n("use for a KDE-Application with toolbar ect."));
  connect(kna,SIGNAL(clicked()),SLOT(slotAppClicked()));
  kma = new QRadioButton (i18n("KDE-Mini-Application"),widget0);
  kma->setGeometry(30,230,150,30);
  QToolTip::add(kma,i18n("use for a minimal KDE-Application"));
  connect(kma,SIGNAL(clicked()),SLOT(slotMiniClicked()));
  bgroup->insert( kna );
  bgroup->insert( kma );
    
  /************************************************************/
  
  // create the second page
  page1 = new KWizardPage;
  widget1 = new QWidget(this);
  page1->w = widget1;
  page1->title = (i18n("Names"));
  addPage(page1);  
  
  // create Labels with LineEdit and a Button
  name = new QLabel(i18n("Projectname:"),widget1);
  name->move(20,10);
  directory = new QLabel(i18n("Projectdirectory:"),widget1);
  directory->move(20,70);
  versionnumber = new QLabel(i18n("Versionsnumber:"),widget1);
  versionnumber->move(20,130);
  separator2 = new KSeparator (widget1);
  separator2->setGeometry(0,172,400,10);
  authorname = new QLabel(i18n("Author:"),widget1);
  authorname->move(20,195);
  email = new QLabel(i18n("Email:"),widget1);
  email->move(20,255);
  nameline = new QLineEdit(widget1);
  nameline->setGeometry(120,10,200,30);
  QToolTip::add(nameline,i18n("enter the projectname"));
  connect(nameline,SIGNAL(textChanged(const char*)),SLOT(slotProjectnameEntry()));
  directoryline = new QLineEdit(widget1);
  directoryline->setGeometry(120,70,200,30);
  QToolTip::add(directoryline,i18n("the directory, in which your project is"));
  directoryload = new QPushButton ("...",widget1);
  directoryload->setGeometry(330,70,30,30);
  QToolTip::add(directoryload,i18n("you can browse to a directory here"));
  connect(directoryload,SIGNAL(clicked()),SLOT(slotDirDialogClicked()));
  versionline = new QLineEdit(widget1);
  versionline->setGeometry(120,130,200,30);
  QToolTip::add(versionline,i18n("the versionsnumber, with which your project should start"));
  authorline = new QLineEdit(widget1);
  authorline->setGeometry(120,195,200,30);
  QToolTip::add(authorline,i18n("enter your name"));
  emailline = new QLineEdit(widget1);
  emailline->setGeometry(120,255,200,30);
  QToolTip::add(emailline,i18n("enter your email-address"));
  
  /************************************************************/
  
  // create the third page
  page2 = new KWizardPage;
  widget2 = new QWidget(this);
  page2->w = widget2;
  page2->title = (i18n("Projectfiles & Desktopgoodies"));
  addPage(page2);
  
  // create CheckBoxes  with help
  apidoc = new QCheckBox (i18n("API-Documentation"), widget2);
  apidoc->setGeometry(20,5,140,30);
  QToolTip::add(apidoc,i18n("activate, if you wish the API-Documentationfiles"));
  userdoc = new QCheckBox (i18n("User-Dokumentation"), widget2);
  userdoc->setGeometry(20,45,140,30);
  QToolTip::add(userdoc,i18n("activate, if you wish the User-Documentationfiles"));
  lsmfile = new QCheckBox (i18n("lsm-File - Linux Software Map"), widget2);
  lsmfile->setGeometry(20,85,300,30);
  QToolTip::add(lsmfile,i18n("activate, if you wish the lsm-File"));
  gnufiles = new QCheckBox (i18n("GNU-Standard-Files (INSTALL,README,COPYING...)"), widget2);
  gnufiles->setGeometry(20,125,350,30);
  QToolTip::add(gnufiles,i18n("activate, if you wish the GNU-Standard-Files"));
  separator1 = new KSeparator (widget2);
  separator1->setGeometry(0,165,400,10);
  progicon = new QCheckBox (i18n("Program-Icon"), widget2);
  progicon->setGeometry(20,190,140,30);
  connect(progicon,SIGNAL(clicked()),SLOT(slotProgIconClicked()));   
  QToolTip::add(progicon,i18n("activate, if you want an icon for your program"));
  miniicon = new QCheckBox (i18n("Mini-Icon"), widget2);
  miniicon->setGeometry(20,250,140,30);
  connect(miniicon,SIGNAL(clicked()),SLOT(slotMiniIconClicked()));   
  QToolTip::add(miniicon,i18n("activate, if you want a mini-icon for your program"));
  datalink = new QCheckBox (i18n(".kdelnk-File"), widget2);
  datalink->setGeometry(240,190,140,30);
  QToolTip::add(datalink,i18n("activate, if you want a link in the K-Menu"));
  // create PushButtons for the icons with help and connections
  iconload = new QPushButton(widget2);
  iconload->setGeometry(140,183,55,55);
  QToolTip::add(iconload,i18n("you can select another icon here"));
  connect(iconload,SIGNAL(clicked()),SLOT(slotIconButtonClicked()));
  miniload = new QPushButton(widget2);
  miniload->setGeometry(165,250,30,30);
  QToolTip::add(miniload,i18n("you can select another mini-icon here"));
  connect(miniload,SIGNAL(clicked()),SLOT(slotMiniIconButtonClicked()));
  
  /************************************************************/
  
  // create the fourth page
  page3 = new KWizardPage;
  widget3 = new QWidget(this);
  page3->w = widget3;
  page3->title = (i18n("Headertemplate for .h-files"));
  addPage(page3);
  
  // create a CheckBox, two PushButtons and a KEdit for the Headertemplate
  hheader = new QCheckBox (i18n("headertemplate for .h-files"), widget3);
  hheader->setGeometry(20,10,190,30);
  connect(hheader,SIGNAL(clicked()),SLOT(slotHeaderHeaderClicked()));   
  QToolTip::add(hheader,i18n("activate, if you want a headertemplate for your headerfiles"));
  hload = new QPushButton (i18n("Load..."),widget3);
  hload->setGeometry(210,10,60,30);
  QToolTip::add(hload,i18n("you can load another headertemplate here"));
  connect(hload,SIGNAL(clicked()),SLOT(slotHeaderDialogClicked()));
  hnew = new QPushButton (i18n("New"),widget3);
  hnew->setGeometry(300,10,60,30);
  QToolTip::add(hnew,i18n("you can clear the headertemplate here"));
  connect(hnew,SIGNAL(clicked()),SLOT(slotNewHeaderButtonClicked()));
  hedit = new KEdit(kapp,widget3);
  QFont f("fixed",10);
  hedit->setFont(f);
  hedit->setGeometry(20,60,340,230);
  QToolTip::add(hedit,i18n("you can edit your headertemplate here"));
  
  /************************************************************/
  
  // create the fifth page
  page4 = new KWizardPage;
  widget4 = new QWidget(this);
  page4->w = widget4;
  page4->title = (i18n("Headertemplate for .cpp-files"));
  addPage(page4);
  
  // create a CheckBox, two PushButtons and a KEdit for the Cpptemplate
  cppheader = new QCheckBox (i18n("headertemplate for .cpp-files"), widget4);
  cppheader->setGeometry(20,10,190,30);
  connect(cppheader,SIGNAL(clicked()),SLOT(slotCppHeaderClicked()));   
  QToolTip::add(cppheader,i18n("activate, if you want a cpptemplate for your cppfiles"));
  cppload = new QPushButton (i18n("Load..."),widget4);
  cppload->setGeometry(210,10,60,30);
  QToolTip::add(cppload,i18n("you can load another cpptemplate here"));
  connect(cppload,SIGNAL(clicked()),SLOT(slotCppDialogClicked()));
  cppnew = new QPushButton (i18n("New"),widget4);
  cppnew->setGeometry(300,10,60,30);
  QToolTip::add(cppnew,i18n("you can clear the cpptemplate here"));
  connect(cppnew,SIGNAL(clicked()),SLOT(slotNewCppButtonClicked()));   
  cppedit = new KEdit(kapp,widget4);
  cppedit->setFont(f);
  cppedit->setGeometry(20,60,340,230);
  QToolTip::add(cppedit,i18n("you can edit your cpptemplate here"));
  
  /************************************************************/
  
  // create the sixth page
  page5 = new KWizardPage;
  widget5 = new QWidget(this);
  page5->w = widget5;
  page5->title = (i18n("Processes"));
  addPage(page5);
  
  // create a MultiLineEdit for the processes of kAppWizard
  output = new QMultiLineEdit(widget5);
  output->setGeometry(5,5,375,225);
  output->setReadOnly(true);
  QFont font("helvetica",10);
  output->setFont(font);
  QToolTip::add(output,i18n("you can see the normal outputs here"));
  errOutput = new QMultiLineEdit(widget5);
  errOutput->setGeometry(5,230,375,65);
  errOutput->setReadOnly(true);
  errOutput->setFont(font);
  QToolTip::add(errOutput,i18n("you can see all warnings and errormessages here"));
  // go to page 2 then to page 1
  gotoPage(1);  
  gotoPage(0);    
}

// connection to directoryload
void KAppWizard::slotDirDialogClicked() {
  dirdialog = new KDirDialog(directoryline->text(),this,"Directory");
  dirdialog->setCaption ("Directory");
  dirdialog->show();
  dir = dirdialog->dirPath();
  directoryline->setText(dir);
  delete (dirdialog);
}

// connection of hload
void KAppWizard::slotHeaderDialogClicked() {
  headerdialog = new KFileDialog(QDir::homeDirPath(),"*",this,"Headertemplate",true,true);
  headerdialog->setCaption ("Header");
  headerdialog->show();
  hedit->loadFile(headerdialog->selectedFile(),cppedit->OPEN_READWRITE);
  delete (headerdialog);
}

// connection of cppload
void KAppWizard::slotCppDialogClicked() {
  cppdialog = new KFileDialog(QDir::homeDirPath(),"*",this,"Cpptemplate",true,true);
  cppdialog->setCaption("Cpp");
  cppdialog->show();
  cppedit->loadFile(cppdialog->selectedFile(),cppedit->OPEN_READWRITE);
  delete (cppdialog);
}

// connection of hnew
void KAppWizard::slotNewHeaderButtonClicked() {
  hedit->clear();
}

// connection of cppnew
void KAppWizard::slotNewCppButtonClicked() {
  cppedit->clear();
}

// connection of this (defaultButton)
void KAppWizard::slotOkClicked() {
  errOutput->clear();
  output->clear();
  QDir kdevelop;
  kdevelop.mkdir(QDir::homeDirPath() + "/.kdevelop");
  cppedit->setName(QDir::homeDirPath() + "/.kdevelop/cpp");
  cppedit->toggleModified(true);
  cppedit->doSave();
  hedit->setName(QDir::homeDirPath() + "/.kdevelop/header");
  hedit->toggleModified(true);
  hedit->doSave();
  ofstream entries (QDir::homeDirPath() + "/.kdevelop/entries");
  entries << "APPLICATION\n";
  if (kna->isChecked()) 
    entries << "standard\n";
  else 
    entries << "mini\n";
  entries << "NAME\n";
  entries << nameline->text() << "\n";
  entries << "DIRECTORY\n";
  entries << directoryline->text() << "\n";
  entries << "AUTHOR\n";
  entries << authorline->text() << "\n";
  entries << "EMAIL\n";
  entries << emailline->text() << "\n";
  entries << "API\n";
  if (apidoc->isChecked())
    entries << "yes\n";
  else entries << "no\n";
  entries << "USER\n";
  if (userdoc->isChecked())
    entries << "yes\n";
  else entries << "no\n";
  entries << "LSM\n";
  if (lsmfile->isChecked())
    entries << "yes\n";
  else entries << "no\n";
  entries << "GNU\n";
  if (gnufiles->isChecked())
    entries << "yes\n";
  else entries << "no\n";
  entries << "PROGICON\n";
  if (progicon->isChecked()) {
    entries << name1 << "\n";
  }
  else entries << "no\n";
  entries << "MINIICON\n";
  if (miniicon->isChecked())
    entries << name2 << "\n";
  else entries << "no\n";
  entries << "KDELNK\n";
  if (datalink->isChecked())
    entries << "yes\n";
  else entries << "no\n";
  entries << "HEADER\n";
  if (hheader->isChecked())
    entries << "yes\n";
  else entries << "no\n";
  entries << "CPP\n";
  if (cppheader->isChecked())
    entries << "yes\n";
  else entries << "no\n";
  entries << "VERSION\n";
  entries << versionline->text() << "\n";

  p = new KProcess();
  connect(p,SIGNAL(receivedStdout(KProcess *, char *, int)),
          this,SLOT(slotPerlOut(KProcess *, char *, int)));
  connect(p,SIGNAL(receivedStderr(KProcess *, char *, int)),
          this,SLOT(slotPerlErr(KProcess *, char *, int)));
  QString path = kapp->kde_datadir()+"/kdevelop/tools/";
  *p << "perl" << path + "processes.pl";
  p->start(KProcess::NotifyOnExit, KProcess::AllOutput);
  okButton->setEnabled(false);
  gotoPage(5);
}

// connection of this (cancelButton)
void KAppWizard::slotAppEnd() {
  close();
}

// connection of this (okButton)
void KAppWizard::slotPerlOut(KProcess*,char* buffer,int buflen) {
  QString str(buffer,buflen);
  output->append(str);
  output->setCursorPosition(output->numLines(),0);
}

// connection of this (okButton)
void KAppWizard::slotPerlErr(KProcess*,char* buffer,int buflen) {
  QString str(buffer,buflen);
  errOutput->append(str);
  errOutput->setCursorPosition(errOutput->numLines(),0);
}

// connection of kna
void KAppWizard::slotAppClicked() {
  pm.load(KApplication::kde_datadir() +"/kdevelop/pics/normalApp.bmp");
  widget1b->setBackgroundPixmap(pm);
}

// connection of kma
void KAppWizard::slotMiniClicked() {
  pm.load(KApplication::kde_datadir() + "/kdevelop/pics/miniApp.bmp");
  widget1b->setBackgroundPixmap(pm);
}

// connection of this
void KAppWizard::slotDefaultClicked() {
  kma->setChecked(false);
  kna->setChecked(true);
  pm.load(KApplication::kde_datadir() +"/kdevelop/pics/normalApp.bmp");
  widget1b->setBackgroundPixmap(pm);
  apidoc->setChecked(true);
  lsmfile->setChecked(true);
  cppheader->setChecked(true);
  hheader->setChecked(true);
  datalink->setChecked(true);
  miniicon->setChecked(true);
  progicon->setChecked(true);
  gnufiles->setChecked(true);
  userdoc->setChecked(true);
  directoryline->setText(QDir::homeDirPath()+ "/");
  dir = QDir::homeDirPath();
  nameline->setText(0);
  okButton->setEnabled(false);
  miniload->setPixmap("/opt/kde/share/icons/mini/application_settings.xpm");
  iconload->setPixmap("/opt/kde/share/icons/edit.xpm");
  cppedit->loadFile(KApplication::kde_datadir() + "/kdevelop/templates/cpp_template",cppedit->OPEN_READWRITE);
  hedit->loadFile(KApplication::kde_datadir() + "/kdevelop/templates/header_template",hedit->OPEN_READWRITE);
  authorline->setText(0);
  emailline->setText(0);
}

// connection of nameline
void KAppWizard::slotProjectnameEntry() {
  nametext = nameline->text();
  nametext = nametext.stripWhiteSpace();
  if (nametext.length() == 1) {
    QRegExp regexp ("[a-zA-Z]");
    if (regexp.match(nametext) == -1) {
      nametext = "";
    }
    else {
      nametext = nametext.upper();
    }
  }
  nameline->setText(nametext);
  nametext == "" ? okButton->setEnabled(false) : okButton->setEnabled(true);
}

// connection of iconload
void KAppWizard::slotIconButtonClicked() {
  QStrList iconlist;
  KIconLoaderDialog iload;
  iconlist.append (KApplication::kde_icondir());
  iconlist.append (KApplication::localkdedir()+"/share/icons");
  iload.setDir(&iconlist);
  iload.selectIcon(name1,"*");
  if (!name1.isNull() )   
    iconload->setPixmap(kapp->getIconLoader()->loadIcon(name1));
}

// connection of miniload
void KAppWizard::slotMiniIconButtonClicked() {
  QStrList miniiconlist;
  KIconLoaderDialog  mload;
  miniiconlist.append (KApplication::kde_icondir()+"/mini");
  miniiconlist.append (KApplication::localkdedir()+"/share/icons/mini");
  mload.setDir(&miniiconlist);
  mload.selectIcon(name2,"*");
  if (!name2.isNull() )     
    miniload->setPixmap(kapp->getIconLoader()->loadMiniIcon(name2));
}

// activate and deactivate the iconbutton
void KAppWizard::slotProgIconClicked() {
  if (progicon->isChecked()) {
    iconload->setEnabled(true);
  }
  else {
    iconload->setEnabled(false);
  }
}

// activate and deactivate the miniiconbutton
void KAppWizard::slotMiniIconClicked() {
  if (miniicon->isChecked()) {
    miniload->setEnabled(true);
  }
  else {
    miniload->setEnabled(false);
  }
}

// activate and deactivate the headerloadbutton, headernewbutton, headeredit
void KAppWizard::slotHeaderHeaderClicked() {
  if (hheader->isChecked()) {
    hload->setEnabled(true);
    hnew->setEnabled(true);
    hedit->setEnabled(true);
  }
  else {
    hload->setEnabled(false);
    hnew->setEnabled(false);
    hedit->setEnabled(false);
  }
}

// activate and deactivate the cpploadbutton, cppnewbutton, cppedit
void KAppWizard::slotCppHeaderClicked() {
  if (cppheader->isChecked()) {
    cppload->setEnabled(true);
    cppnew->setEnabled(true);
    cppedit->setEnabled(true);
  }
  else {
    cppload->setEnabled(false);
    cppnew->setEnabled(false);
    cppedit->setEnabled(false);
  }
}

// return the directory with the projectfile
QString KAppWizard::getProjectFile() {
  nametext = nameline->text();
  nametext = nametext.lower();
  directorytext = directoryline->text();
  directorytext = directorytext + nametext + "/" + nametext + ".kdevprj";
  return directorytext;
}

