/***************************************************************************
                    kdevelop.cpp - the main class in KDevelop
                             -------------------                                         

    version              :                                   
    begin                : 20 Jul 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kdevelop.h"
#include <kmsgbox.h>
#include <qfile.h>
#include <qtstream.h>
#include <iostream.h>
#include <kfiledialog.h>
#include <qfont.h>
#include <qfileinf.h>
#include <ktabctl.h>
#include <qregexp.h>
#include "kdevsetup.h"
#include "kappwizard.h"



void KDevelop::slotFileNewAppl(){
  KAppWizard* kappw  = new KAppWizard (this,"zutuz");
  //cerr << kappw->getProjectFile();
  readProjectFile(kappw->getProjectFile());
}
void KDevelop::slotFileNewFile(){
  newFile(false);
}


void KDevelop::slotFileOpenFile(){
  QString str;
  str = KFileDialog::getOpenFileName(prj.dir,"*.*",this);
  if (str.isEmpty()) return; //cancel
  switchToFile(str);
  
  
}
void KDevelop::slotFileOpenPrj(){
  QString str;
  str = KFileDialog::getOpenFileName(prj.dir,"*.kdevprj",this);
  if (str.isEmpty()) return; //cancel
  QFileInfo info(str);
  
  if (info.isFile()){
    readProjectFile(str);
  }
}
void KDevelop::slotFileSave(){

  if((edit_widget->getName() == "Untitled.cpp") || (edit_widget->getName() == "Untitled.h")){
    slotFileSaveAs();
  }
  else{
    edit_widget->doSave();
  }
  slotOptionsRefresh();
}
void KDevelop::slotFileSaveAs(){
  QString name;
  TEditInfo* actual_info;
  name = KFileDialog::getSaveFileName(prj.dir,0,this,edit_widget->getName());
  if (name.isNull()){
     cerr << "CANCEL";
     return;
   }
   else {
     edit_widget->toggleModified(true);
     edit_widget->doSave(name); // try the save
     //     if (err == KEdit::KEDIT_OS_ERROR){
     //  cerr << "error";
     //  return; // no action
     // }
  // and now the modifications for the new file
  //search the actual edit_info
  for(actual_info=edit_infos.first();actual_info != 0;actual_info=edit_infos.next()){
    if (actual_info->filename == edit_widget->getName()){ // found
	
 	//update the info-struct in the list
      actual_info->filename = name;
      actual_info->modified = false;
      //update the widget
      edit_widget->setName(name);
      edit_widget->toggleModified(false);
      //update the menu
      QFileInfo fileinfo(name);
      menu_buffers->changeItem(fileinfo.fileName(),actual_info->id);
      //update kdevelop
      setCaption(name);
    }
  } // end_for
} // end_else
}

void KDevelop::slotFileClose(){
  TEditInfo* actual_info;
  int message_result;
  
  if(edit_widget->isModified()){
    message_result = KMsgBox::yesNoCancel(this,i18n("Save?"),
					  i18n("The document was modified,save?"),KMsgBox::QUESTION);
    if (message_result == 1){ // yes
      edit_widget->doSave();
    }
    if (message_result == 3){ // cancel
      return;
    }
  }
  
  //search the actual edit_info and remove it
  for(actual_info=edit_infos.first();actual_info != 0;actual_info=edit_infos.next()){
    if (actual_info->filename == edit_widget->getName()){ // found
             cerr << "LEITE REMOVE EIN";
             menu_buffers->removeItem(actual_info->id);
	     if(edit_infos.removeRef(actual_info)){
	cerr << "REMOVE GEKLAPPT";
       }
    }
  }
  // add the next edit to the location
   for(actual_info=edit_infos.first();actual_info != 0;actual_info=edit_infos.next()){
     if ( getTabLocation(actual_info->filename) == getTabLocation(edit_widget->getName())){ // found
       edit_widget->setText(actual_info->text);
       edit_widget->toggleModified(actual_info->modified);
       edit_widget->setName(actual_info->filename);
       setCaption(actual_info->filename);
       cerr << "FOUND A NEXT" << actual_info->filename;
       return;
     }
   }
   // if not found a successor create an new file
   
   actual_info = new TEditInfo;
   actual_info->modified=false;
   if (getTabLocation(edit_widget->getName()) == 0) {// header
     actual_info->id = menu_buffers->insertItem("Untitled.h",-2,0);
     actual_info->filename = "Untitled.h";
  }
   else{
     actual_info->id = menu_buffers->insertItem("Untitled.cpp",-2,0);
     actual_info->filename = "Untitled.cpp";
   }
   edit_infos.append(actual_info);
   edit_widget->setName(actual_info->filename);
   edit_widget->clear();
   setCaption(actual_info->filename);
  
}
void KDevelop::closeEvent(QCloseEvent* e){
  e->accept();
  cerr << "QUIT";
  config->setGroup("General Options");
  config->writeEntry("width",width());
  config->writeEntry("height",height());
  config->writeEntry("view_panner_pos",view->absSeparatorPos());
  config->writeEntry("top_panner_pos",top_panner->absSeparatorPos());
  config->setGroup("Files");
  config->writeEntry("project_file",prj.prjfile);
  config->writeEntry("cpp_file",cpp_widget->getName());
  config->writeEntry("header_file",header_widget->getName());
  config->writeEntry("browser_file",history_list.current());
  //config->writeEntry("x",x());
  //config->writeEntry("y",y());
  config->sync();
  KTMainWindow::closeEvent(e);
}

void KDevelop::slotFileQuit(){
  close(); 
}
void KDevelop::slotEditCut(){
  edit_widget->cut();
}
void KDevelop::slotEditCopy(){
  edit_widget->copyText();
}
void KDevelop::slotEditPaste(){
  edit_widget->paste();
}
void KDevelop::slotEditSelectAll(){
  edit_widget->selectAll();
}
void KDevelop::slotEditInsertFile(){
  edit_widget->insertFile();
}
void KDevelop::slotEditSearch(){
  edit_widget->search();
}
void KDevelop::slotEditRepeatSearch(){
  edit_widget->searchAgain();
}
void KDevelop::slotEditReplace(){
  edit_widget->replace();
}
void KDevelop::slotEditGotoLine(){
  edit_widget->gotoLine();
}
void KDevelop::slotOptionsTStdToolbar(){
  enableToolBar();
}
void KDevelop::slotOptionsTBrowserToolbar(){
  enableToolBar(KToolBar::Toggle,1);
}

void KDevelop::slotOptionsTStatusbar(){
  enableStatusBar();
}


void KDevelop::slotOptionsRefresh(){
  refreshTrees();
}
void KDevelop::slotOptionsConfKDevelop(){
  new KDevSetup();
}

void KDevelop::slotDocBack(){
  int id;
  QString str = history_list.prev();
  if (str != 0){
    s_tab_view->setCurrentTab(BROWSER);
    browser_widget->showURL(str);
    toolBar(1)->setItemEnabled(TOOLBAR_FORWARD,true);
    id = documentation_menu->idAt(1);
    documentation_menu->setItemEnabled(id,true); // forward
  }
  if (history_list.prev() == 0){ // no more backs
    toolBar(1)->setItemEnabled(TOOLBAR_BACK,false);
    id = documentation_menu->idAt(0);
    documentation_menu->setItemEnabled(id,false); // forward
    history_list.first(); // set it at first
  }
  else{
    history_list.next();
  }
  cerr << endl << "COUNT HISTORYLIST:" << history_list.count();;
}
void KDevelop::slotDocForward(){
  int id;
  QString str = history_list.next();
  if (str != 0){
    s_tab_view->setCurrentTab(BROWSER);
    browser_widget->showURL(str);
    toolBar(1)->setItemEnabled(TOOLBAR_BACK,true);
    id = documentation_menu->idAt(0);
    documentation_menu->setItemEnabled(id,true); // forward
  }
  if (history_list.next() == 0){ // no more forwards
    toolBar(1)->setItemEnabled(TOOLBAR_FORWARD,false);
    id = documentation_menu->idAt(1);
    documentation_menu->setItemEnabled(id,false); // forward
    history_list.last(); // set it at last
  }
  else{
    history_list.prev();
  }
} 
void KDevelop::slotDocSClass(){
  QString classname = edit_widget->markedText();
  config->setGroup("Doc_Location");
  QString filename =  config->readEntry("doc_qt") + classname.lower() + ".html";
  if (QFile::exists(filename)){
    slotURLSelected(browser_widget,filename,1,"test");
  }
  filename = config->readEntry("doc_kde_core") + classname + ".html";
  if (QFile::exists(filename)){
    slotURLSelected(browser_widget,filename,1,"test");
  }
  filename =  config->readEntry("doc_kde_gui") + classname + ".html";
  if (QFile::exists(filename)){
    slotURLSelected(browser_widget,filename,1,"test");
  }
  filename =  config->readEntry("doc_kde_kfile") + classname + ".html";
  if (QFile::exists(filename)){
    slotURLSelected(browser_widget,filename,1,"test");
  }
  filename =  config->readEntry("doc_kde_html") + classname + ".html";
  if (QFile::exists(filename)){
    slotURLSelected(browser_widget,filename,1,"test");
  }
}
void KDevelop::slotDocQtLib(){
  config->setGroup("Doc_Location");
  slotURLSelected(browser_widget,"file:" + config->readEntry("doc_qt") + "index.html",1,"test");
}
void KDevelop::slotDocKDECoreLib(){
  config->setGroup("Doc_Location");
  slotURLSelected(browser_widget,"file:" + config->readEntry("doc_kde_core") + "index.html",1,"test");
}
void KDevelop::slotDocKDEGUILib(){
  config->setGroup("Doc_Location");
  slotURLSelected(browser_widget,"file:" +  config->readEntry("doc_kde_gui") + "index.html",1,"test");
}
void KDevelop::slotDocKDEKFileLib(){
  config->setGroup("Doc_Location");
  slotURLSelected(browser_widget,"file:" +  config->readEntry("doc_kde_kfile") + "index.html",1,"test");
}
void KDevelop::slotDocKDEHTMLLib(){
  config->setGroup("Doc_Location");
  slotURLSelected(browser_widget,"file:" +  config->readEntry("doc_kde_html") + "index.html",1,"test");
}


void KDevelop::slotDocAPI(){
  slotURLSelected(browser_widget,prj.dir + prj.sub_dir +  "api/index.html",1,"test");
}
void KDevelop::slotDocManual(){
  unsigned int index = prj.sgml_file.length()-4;
  QString name = prj.sgml_file.copy();
  name.remove(index,4);
  slotURLSelected(browser_widget,prj.dir + prj.sub_dir + "docs/en/" + name + "html",1,"test");
}

void KDevelop::slotBuildRun(){
  slotBuildMake();
  next_job = "run";
}
void KDevelop::slotBuildMake(){
  setToolMenuProcess(false);
  slotFileSave();
  output_widget->clear();
  QDir::setCurrent(prj.dir + prj.sub_dir); 
  process.clearArguments();
  process << "make";
  
  process.start(KProcess::NotifyOnExit,KProcess::AllOutput);
}
void KDevelop::slotBuildRebuildAll(){
  setToolMenuProcess(false);
  slotFileSave();
  output_widget->clear();
  QDir::setCurrent(prj.dir + prj.sub_dir); 
  process.clearArguments();
  process << "make";
  process << "clean";
  next_job = "make"; // checked in slotProcessExited()
  
  process.start(KProcess::NotifyOnExit,KProcess::AllOutput);
}
void KDevelop::slotBuildCleanRebuildAll(){
  setToolMenuProcess(false);
  slotFileSave();
  output_widget->clear();
  QDir::setCurrent(prj.dir); 
  process.clearArguments();
  QString path = kapp->kde_datadir()+"/kdevelop/tools/";
  process << "sh" << path + "cleanrebuildall";
  
  process.start(KProcess::NotifyOnExit,KProcess::AllOutput);

}
void KDevelop::slotBuildStop(){
  setToolMenuProcess(true);
  process.kill();
  shell_process.kill();
}
void KDevelop::slotBuildAPI(){
  setToolMenuProcess(false);
  slotFileSave();
  output_widget->clear();
  QDir::setCurrent(prj.dir + prj.sub_dir); 
  shell_process.clearArguments();
  shell_process << "kdoc";
  shell_process << "-p -d" + prj.dir + prj.sub_dir +  "api";
  shell_process << prj.name;
  shell_process << "*.h";
  
  shell_process.start(KShellProcess::NotifyOnExit,KShellProcess::AllOutput);
  
  
}
void KDevelop::slotBuildManual(){
  setToolMenuProcess(false);
  slotFileSave();
  output_widget->clear();
  QDir::setCurrent(prj.dir + prj.sub_dir + "/docs/en/");
  process.clearArguments();
  process << "sgml2html";
  process << prj.sgml_file;
  process.start(KProcess::NotifyOnExit,KProcess::AllOutput); 
}


void KDevelop::slotBookmarksAdd(){
}
void KDevelop::slotBookmarksEdit(){
}

void KDevelop::slotURLSelected(KHTMLView* ,const char* url,int,const char*){
  int id;
  s_tab_view->setCurrentTab(BROWSER);
  browser_widget->showURL(url);

  if (!history_list.isEmpty()){
    toolBar(1)->setItemEnabled(TOOLBAR_BACK,true);
    id = documentation_menu->idAt(0);
    documentation_menu->setItemEnabled(id,true); // back
  }
  // insert into the history-list
  history_list.append(url);
}

void KDevelop::slotReceivedStdout(KProcess*,char* buffer,int buflen){ 
  int x,y;
  output_widget->cursorPosition(&x,&y);
  QString str(buffer,buflen+1);
  output_widget->insertAt(str,x,y);
}
void KDevelop::slotReceivedStderr(KProcess*,char* buffer,int buflen){ 
 
  int x,y;
  output_widget->cursorPosition(&x,&y);
  QString str(buffer,buflen+1);
  output_widget->insertAt(str,x,y);
}

void KDevelop::slotClickedOnOutputWidget(){
  int x,y;
  int error_line;
  QString text;
  QString error_line_str;
  QString error_filename;
  int pos1,pos2; // positions in the string
  QRegExp reg(":[0-9]*:"); // is it a error line?, I hope it works

  output_widget->cursorPosition(&x,&y);
  text = output_widget->textLine(x);
  if((pos1=reg.match(text)) == -1) return; // not a error line

  // extract the error-line
  pos2 = text.find(':',pos1+1);
  error_line_str = text.mid(pos1+1,pos2-pos1-1);
  error_line = error_line_str.toInt();

  // extract the filename
  pos2 = text.findRev(' ',pos1);
  if (pos2 == -1) {
    pos2 = 0; // the filename is at the begining of the string
  }
  else { pos2++; }

  error_filename = text.mid(pos2,pos1-pos2);

  // switch to the file
  if (error_filename.find('/') == -1){ // it is a file outer the projectdir ?
    error_filename = prj.dir + prj.sub_dir + error_filename;
  }
  if (QFile::exists(error_filename)){
    switchToFile(error_filename);
    edit_widget->setCursorPosition(error_line-1,0);
    edit_widget->setFocus();
  }

}
void KDevelop::slotProcessExited(KProcess*){
  setToolMenuProcess(true);
  if (next_job == "make"){ // rest from the rebuild all
    QDir::setCurrent(prj.dir + prj.sub_dir); 
    process.clearArguments();
    process << "make";
    setToolMenuProcess(false);
    process.start(KProcess::NotifyOnExit,KProcess::AllOutput);
    next_job = "";
  }
  if (next_job == "run"){ // rest from the buildRun
    QDir::setCurrent(prj.dir + prj.sub_dir); 
    process.clearArguments();
    process << prj.name.lower();;
    setToolMenuProcess(false);
    process.start(KProcess::NotifyOnExit,KProcess::AllOutput);
    next_job = "";
  }
  if (next_job == "refresh"){ // rest from the add projectfile
    refreshTrees();
  }
}

void KDevelop::slotSTabSelected(int item){
  if (item == 0){
    edit_widget = header_widget;
  }
  if (item == 1){
    edit_widget = cpp_widget;
  }
  setCaption("KDevelop V" + version + ": " + edit_widget->getName());
  //  s_tab_current = item;
  edit_widget->setFocus();
}

void KDevelop::slotMenuBuffersSelected(int id){
  TEditInfo* info;
  
  for(info=edit_infos.first();info != 0;info=edit_infos.next()){
    if (info->id == id){
      switchToFile(info->filename);
      return; // if found than return
    }
  }  
}


void KDevelop::slotLogFileTreeSelected(int index){
  KPath* path;
  QString* str;
  QString* str2;
  if (log_file_tree->itemAt(index)->hasChild() == true) return; // no action
  path = log_file_tree->itemPath(index);
  str = path->pop();
  str2 = path->pop();
 
  if (*str2 == "Headers"){
    switchToFile(prj.dir + prj.sub_dir + *str);
  }
  if (*str2 == "Sources" ){
    switchToFile(prj.dir + prj.sub_dir + *str);
  }
  if (*str2 == "GNU"){
    switchToFile(prj.dir + *str);
  }
  if (*str2 == "Linux"){
    switchToFile(prj.dir + *str);
  }
  if (*str2 == "KDE"){
    if (str->contains(".sgml")){
      switchToFile(prj.dir + prj.sub_dir + "docs/en/" + *str);
    }
    if (str->contains(".kdelnk")){
      switchToFile(prj.dir + prj.sub_dir + *str);
    }
  }
  if (*str2 == "Other"){
    switchToFile(prj.dir + prj.sub_dir + *str);
  }
}

void KDevelop::slotRealFileTreeSelected(int index){

  if (real_file_tree->itemAt(index)->hasChild() == true) return; // no action
  KPath* path = real_file_tree->itemPath(index);
  QString str_path;
  QString* str;
  cerr << index;
  while ((str = path->pop()) != 0){
    str_path =  "/" + *str + str_path;
  }
  cerr << str_path;
  switchToFile(str_path);
  
}
void KDevelop::slotToolbarClicked(int item){
  switch (item) {
  case TOOLBAR_NEW:
    slotFileNewFile();
    break;
  case TOOLBAR_OPEN:
    slotFileOpenFile();
    break;
  case TOOLBAR_SAVE:
    slotFileSave();
    break;
    
  case TOOLBAR_COPY:
    slotEditCopy();
    break;
  case TOOLBAR_PASTE:
    slotEditPaste();
    break;
  case TOOLBAR_CUT:
    slotEditCut();
    break;
  case TOOLBAR_REFRESH:
    slotOptionsRefresh();
    break;
  case TOOLBAR_MAKE:
    slotBuildMake();
    break;
  case TOOLBAR_RUN:
    slotBuildRun();
    break;
  case TOOLBAR_STOP:
    slotBuildStop();
    break;
  case TOOLBAR_SCLASS:
    slotDocSClass();
    break;
  case TOOLBAR_BACK:
    slotDocBack();
    break;
  case TOOLBAR_FORWARD:
    slotDocForward();
    break;
  }
}





