/***************************************************************************
                     kdevsetup.cpp - the setup dialog for KDevelop
                             -------------------                                         

    version              :                                   
    begin                : 17 Aug 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "kdevsetup.h"


// SETUP DIALOG
KDevSetup::KDevSetup( QWidget *parent, const char *name )
    : QTabDialog( parent, name,TRUE )
{
  setFixedSize(462,368);
  

  setCaption( klocale->translate("KDevelop Setup" ));
  KApplication *app=KApplication::getKApplication();
  config=app->getConfig();
  
  
  // ****************** the Doc_LOcation_DLG ********************
  QWidget *w = new QWidget( this, "page one" );    
  config->setGroup("Doc_Location");
  qt_edit = new QLineEdit( w, "qt_edit" );
  qt_edit->setGeometry( 140, 30, 220, 30 );
  qt_edit->setText( config->readEntry("doc_qt"));
  qt_edit->setMaxLength( 32767 );
  
  QPushButton* qt_button;
  qt_button = new QPushButton( w, "qt_button" );
  qt_button->setGeometry( 390, 30, 30, 30 );
  qt_button->setText( "..." );
  connect(qt_button,SIGNAL(clicked()),SLOT(slotQtClicked()));
  
  QLabel* qt_label;
  qt_label = new QLabel( w, "qt_label" );
  qt_label->setGeometry( 10, 30, 80, 30 );
  qt_label->setText( "Qt-Library:" );
  
  kcore_edit = new QLineEdit( w, "kcore_edit");
  kcore_edit->setGeometry( 140, 80, 220, 30 );
  kcore_edit->setText(config->readEntry("doc_kde_core"));
  kcore_edit->setMaxLength( 32767 );
  kcore_edit->setEchoMode( QLineEdit::Normal );
  kcore_edit->setFrame( TRUE );
  
  QPushButton* kcore_button;
  kcore_button = new QPushButton( w, "kcore_button" );
  kcore_button->setGeometry( 390, 80, 30, 30 );
  kcore_button->setText( "..." );
  connect(kcore_button,SIGNAL(clicked()),SLOT(slotKCoreClicked()));
  
  QLabel* kcore_label;
  kcore_label = new QLabel( w, "kcore_label" );
  kcore_label->setGeometry( 10, 80, 130, 30 );
  kcore_label->setText( "KDE-Core-Library:" );
 
  kgui_edit = new QLineEdit( w, "kgui_edit" );
  kgui_edit->setGeometry( 140, 130, 220, 30 );
  kgui_edit->setText( config->readEntry("doc_kde_gui"));
  kgui_edit->setMaxLength( 32767 );
  
  QPushButton* kgui_button;
  kgui_button = new QPushButton( w, "kgui_button" );
  kgui_button->setGeometry( 390, 130, 30, 30 );
  kgui_button->setText( "..." );
  connect(kgui_button,SIGNAL(clicked()),SLOT(slotKGuiClicked()));
  
  QLabel* kgui_label;
  kgui_label = new QLabel( w, "kgui_label" );
  kgui_label->setGeometry( 10, 130, 110, 30 );
  kgui_label->setText( "KDE-GUI-Library:" );
  
  kfile_edit = new QLineEdit( w, "kfile_edit" );
  kfile_edit->setGeometry( 140, 180, 220, 30 );
  kfile_edit->setText( config->readEntry("doc_kde_kfile"));
  kfile_edit->setMaxLength( 32767 );
  
  QPushButton* kfile_button;
  kfile_button = new QPushButton( w, "kfile_button" );
  kfile_button->setGeometry( 390, 180, 30, 30 );
  kfile_button->setText( "..." );
  connect(kfile_button,SIGNAL(clicked()),SLOT(slotKFileClicked()));
	
  QLabel* kfile_label;
  kfile_label = new QLabel( w, "kfile_label" );
  kfile_label->setGeometry( 10, 180, 120, 30 );
  kfile_label->setText( "KDE-KFile-Library:" );
  
  QPushButton* khtml_button;
  khtml_button = new QPushButton( w, "khtml_button" );
  khtml_button->setGeometry( 390, 230, 30, 30 );
  khtml_button->setText( "..." );
  connect(khtml_button,SIGNAL(clicked()),SLOT(slotKHTMLClicked()));
  
  khtml_edit = new QLineEdit( w, "khtml_edit" );
  khtml_edit->setGeometry( 140, 230, 220, 30 );
  khtml_edit->setText( config->readEntry("doc_kde_html") );
  khtml_edit->setMaxLength( 32767 );
  
  QLabel* khtml_label;
  khtml_label = new QLabel( w, "khtml_label" );
  khtml_label->setGeometry( 10, 230, 120, 30 );
  khtml_label->setText( "KDE-HTML-Library:" );
      
  addTab( w, i18n("Doc-Location" ));
  
  
    // **************set the button*********************
  setOkButton(i18n("OK"));
  setCancelButton(i18n("Cancel"));
  connect( this, SIGNAL(applyButtonPressed()), SLOT(ok()) );
  show();
}



  

void KDevSetup::ok(){
  
  QString text;
  config->setGroup("Doc_Location");
  text = qt_edit->text();
  config->writeEntry("doc_qt",text);
  text = kcore_edit->text();
  config->writeEntry("doc_kde_core" , text);
  text = kgui_edit->text();
  config->writeEntry("doc_kde_gui" , text);
  text = kfile_edit->text();
  config->writeEntry("doc_kde_kfile" , text);
  text = khtml_edit->text();
  config->writeEntry("doc_kde_html" , text);
  config->sync();
  close();
}

void KDevSetup::slotQtClicked(){
  QString dir;
  dir = KFileDialog::getDirectory(config->readEntry("doc_qt"));
  if (!dir.isEmpty()){
  qt_edit->setText(dir);
  config->setGroup("Doc_Location");
  config->writeEntry("doc_qt",dir);
  }
}
void KDevSetup::slotKCoreClicked(){
  QString dir;
  dir = KFileDialog::getDirectory(config->readEntry("doc_kde_core"));
  if (!dir.isEmpty()){
  kcore_edit->setText(dir);
 config->setGroup("Doc_Location");
  config->writeEntry("doc_kde_core",dir);
  }
}
void KDevSetup::slotKGuiClicked(){
  QString dir;
  dir = KFileDialog::getDirectory(config->readEntry("doc_kde_gui"));
  if (!dir.isEmpty()){
  kgui_edit->setText(dir);
 config->setGroup("Doc_Location");
  config->writeEntry("doc_kde_gui",dir);
  }
}
void KDevSetup::slotKFileClicked(){
  QString dir;
  dir = KFileDialog::getDirectory(config->readEntry("doc_kde_kfile"));
  if (!dir.isEmpty()){
  kfile_edit->setText(dir);
 config->setGroup("Doc_Location");
  config->writeEntry("doc_kde_kfile",dir);
  }
}
void KDevSetup::slotKHTMLClicked(){
  QString dir;
  dir = KFileDialog::getDirectory(config->readEntry("doc_kde_html"));
  if (!dir.isEmpty()){
  khtml_edit->setText(dir);
 config->setGroup("Doc_Location");
  config->writeEntry("doc_kde_html",dir);
  }
}
